/*
 * Decompiled with CFR 0.152.
 */
package alluxio;

import alluxio.AlluxioURI;
import alluxio.MultiPartSchemeURI;
import alluxio.StandardURI;
import alluxio.collections.Pair;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.net.URISyntaxException;

public interface URI
extends Comparable<URI>,
Serializable {
    public String getAuthority();

    public String getHost();

    public String getPath();

    public String getQuery();

    public int getPort();

    public String getScheme();

    public boolean isAbsolute();

    public java.net.URI getBaseURI();

    public static class Factory {
        private Factory() {
        }

        public static URI create(String uriStr) {
            String path;
            int question;
            int slash;
            Preconditions.checkArgument((uriStr != null ? 1 : 0) != 0, (Object)"Can not create a uri with a null path.");
            if (AlluxioURI.hasWindowsDrive(uriStr, false)) {
                uriStr = "/" + uriStr;
            }
            String scheme = null;
            String authority = null;
            String query = null;
            int start = 0;
            int colon = uriStr.indexOf(58);
            if (colon != -1 && (slash == -1 || colon < slash)) {
                if (slash != -1) {
                    start = slash;
                    for (slash = uriStr.indexOf(47); slash > 0 && uriStr.charAt(slash - 1) == ':'; --slash) {
                    }
                    scheme = uriStr.substring(0, slash);
                } else {
                    scheme = uriStr.substring(0, colon);
                    start = colon + 1;
                }
            }
            if (uriStr.startsWith("//", start) && uriStr.length() - start > 2) {
                int nextSlash = uriStr.indexOf(47, start + 2);
                int authEnd = nextSlash > 0 ? nextSlash : uriStr.length();
                authority = uriStr.substring(start + 2, authEnd);
                start = authEnd;
            }
            if ((question = (path = uriStr.substring(start, uriStr.length())).indexOf(63)) != -1) {
                query = path.substring(question + 1);
                path = path.substring(0, question);
            }
            return Factory.create(scheme, authority, path, query);
        }

        public static URI create(String scheme, String authority, String path, String query) {
            Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"Can not create a uri with a null path.");
            Pair<String, String> schemeComponents = Factory.getSchemeComponents(scheme);
            String schemePrefix = schemeComponents.getFirst();
            scheme = schemeComponents.getSecond();
            if (scheme == null || schemePrefix.isEmpty()) {
                return new StandardURI(scheme, authority, path, query);
            }
            return new MultiPartSchemeURI(schemePrefix, scheme, authority, path, query);
        }

        public static URI create(URI parent, URI child) {
            java.net.URI childUri;
            java.net.URI parentUri;
            String parentPath = parent.getPath();
            if (!parentPath.endsWith("/") && parentPath.length() > 0) {
                parentPath = parentPath + "/";
            }
            try {
                parentUri = new java.net.URI(Factory.getSchemeComponents(parent.getScheme()).getSecond(), parent.getAuthority(), parentPath, parent.getQuery(), null);
                childUri = new java.net.URI(Factory.getSchemeComponents(child.getScheme()).getSecond(), child.getAuthority(), child.getPath(), child.getQuery(), null);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
            java.net.URI resolved = parentUri.resolve(childUri);
            String resolvedScheme = child.getPath() == null || parent.getPath() == null || child.getScheme() != null ? child.getScheme() : parent.getScheme();
            return Factory.create(resolvedScheme, resolved.getAuthority(), resolved.getPath(), resolved.getQuery());
        }

        private static Pair<String, String> getSchemeComponents(String scheme) {
            if (scheme == null) {
                return new Pair<Object, Object>(null, null);
            }
            int colon = scheme.lastIndexOf(58);
            if (colon == -1) {
                return new Pair<String, String>("", scheme);
            }
            return new Pair<String, String>(scheme.substring(0, colon), scheme.substring(colon + 1));
        }
    }
}

