/*
 * Decompiled with CFR 0.152.
 */
package alluxio.collections;

import io.netty.util.internal.chmv8.ConcurrentHashMapV8;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class ConcurrentHashSet<T>
extends AbstractSet<T> {
    private final Map<T, Boolean> mMap;

    public ConcurrentHashSet() {
        this(2, 0.95f, 1);
    }

    public ConcurrentHashSet(int initialCapacity, float loadFactor, int concurrencyLevel) {
        this.mMap = new ConcurrentHashMapV8(initialCapacity, loadFactor, concurrencyLevel);
    }

    @Override
    public Iterator<T> iterator() {
        return this.mMap.keySet().iterator();
    }

    @Override
    public int size() {
        return this.mMap.size();
    }

    @Override
    public boolean add(T element) {
        return this.mMap.put(element, Boolean.TRUE) == null;
    }

    public boolean addIfAbsent(T element) {
        return ((ConcurrentHashMapV8)this.mMap).putIfAbsent(element, (Object)Boolean.TRUE) == null;
    }

    @Override
    public void clear() {
        this.mMap.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.mMap.containsKey(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.mMap.keySet().containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.mMap.isEmpty();
    }

    @Override
    public boolean remove(Object o) {
        return this.mMap.remove(o) != null;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.mMap.keySet().removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.mMap.keySet().retainAll(c);
    }

    @Override
    public Object[] toArray() {
        return this.mMap.keySet().toArray();
    }

    @Override
    public <E> E[] toArray(E[] a) {
        return this.mMap.keySet().toArray(a);
    }

    @Override
    public String toString() {
        return this.mMap.keySet().toString();
    }
}

