/*
 * Decompiled with CFR 0.152.
 */
package alluxio.collections;

import alluxio.collections.FieldIndex;
import alluxio.collections.IndexDefinition;
import alluxio.collections.NonUniqueFieldIndex;
import alluxio.collections.UniqueFieldIndex;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class IndexedSet<T>
extends AbstractSet<T> {
    private final FieldIndex<T> mPrimaryIndex;
    private final Map<IndexDefinition<T>, FieldIndex<T>> mIndices;

    @SafeVarargs
    public IndexedSet(IndexDefinition<T> primaryIndexDefinition, IndexDefinition<T> ... otherIndexDefinitions) {
        Iterable indexDefinitions = Iterables.concat(Arrays.asList(primaryIndexDefinition), Arrays.asList(otherIndexDefinitions));
        HashMap indices = new HashMap();
        for (IndexDefinition indexDefinition : indexDefinitions) {
            FieldIndex index = indexDefinition.isUnique() ? new UniqueFieldIndex(indexDefinition) : new NonUniqueFieldIndex(indexDefinition);
            indices.put(indexDefinition, index);
        }
        this.mPrimaryIndex = (FieldIndex)indices.get(primaryIndexDefinition);
        this.mIndices = Collections.unmodifiableMap(indices);
    }

    @Override
    public void clear() {
        for (T obj : this.mPrimaryIndex) {
            this.remove(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(T object) {
        Preconditions.checkNotNull(object, (Object)"object");
        T t = object;
        synchronized (t) {
            if (!this.mPrimaryIndex.add(object)) {
                return false;
            }
            for (FieldIndex<T> fieldIndex : this.mIndices.values()) {
                fieldIndex.add(object);
            }
        }
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        return new IndexedSetIterator();
    }

    public boolean contains(IndexDefinition<T> indexDefinition, Object value) {
        FieldIndex<T> index = this.mIndices.get(indexDefinition);
        if (index == null) {
            throw new IllegalStateException("the given index isn't defined for this IndexedSet");
        }
        return index.containsField(value);
    }

    public Set<T> getByField(IndexDefinition<T> indexDefinition, Object value) {
        FieldIndex<T> index = this.mIndices.get(indexDefinition);
        if (index == null) {
            throw new IllegalStateException("the given index isn't defined for this IndexedSet");
        }
        return index.getByField(value);
    }

    public T getFirstByField(IndexDefinition<T> indexDefinition, Object value) {
        FieldIndex<T> index = this.mIndices.get(indexDefinition);
        if (index == null) {
            throw new IllegalStateException("the given index isn't defined for this IndexedSet");
        }
        return index.getFirst(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object object) {
        if (object == null) {
            return false;
        }
        Object object2 = object;
        synchronized (object2) {
            if (this.mPrimaryIndex.containsObject(object)) {
                Object tObj = object;
                this.removeFromIndices(tObj);
                return true;
            }
            return false;
        }
    }

    private void removeFromIndices(T object) {
        for (FieldIndex<T> fieldValue : this.mIndices.values()) {
            fieldValue.remove(object);
        }
    }

    public int removeByField(IndexDefinition<T> indexDefinition, Object value) {
        Set<T> toRemove = this.getByField(indexDefinition, value);
        int removed = 0;
        for (T o : toRemove) {
            if (!this.remove(o)) continue;
            ++removed;
        }
        return removed;
    }

    @Override
    public int size() {
        return this.mPrimaryIndex.size();
    }

    private class IndexedSetIterator
    implements Iterator<T> {
        private final Iterator<T> mSetIterator;
        private T mObject;

        public IndexedSetIterator() {
            this.mSetIterator = IndexedSet.this.mPrimaryIndex.iterator();
            this.mObject = null;
        }

        @Override
        public boolean hasNext() {
            return this.mSetIterator.hasNext();
        }

        @Override
        public T next() {
            Object next = this.mSetIterator.next();
            this.mObject = next;
            return next;
        }

        @Override
        public void remove() {
            if (this.mObject == null) {
                throw new IllegalStateException("next() was not called before remove()");
            }
            IndexedSet.this.remove(this.mObject);
            this.mObject = null;
        }
    }
}

