/*
 * Decompiled with CFR 0.152.
 */
package alluxio.collections;

import alluxio.collections.FieldIndex;
import alluxio.collections.IndexDefinition;
import io.netty.util.internal.chmv8.ConcurrentHashMapV8;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class UniqueFieldIndex<T>
implements FieldIndex<T> {
    private final IndexDefinition<T> mIndexDefinition;
    private final ConcurrentHashMapV8<Object, T> mIndexMap = new ConcurrentHashMapV8(8, 0.95f, 8);

    public UniqueFieldIndex(IndexDefinition<T> indexDefinition) {
        this.mIndexDefinition = indexDefinition;
    }

    @Override
    public boolean add(T object) {
        Object fieldValue = this.mIndexDefinition.getFieldValue(object);
        Object previousObject = this.mIndexMap.putIfAbsent(fieldValue, object);
        return previousObject == null || previousObject == object;
    }

    @Override
    public boolean remove(T object) {
        Object fieldValue = this.mIndexDefinition.getFieldValue(object);
        return this.mIndexMap.remove(fieldValue, object);
    }

    @Override
    public void clear() {
        this.mIndexMap.clear();
    }

    @Override
    public boolean containsField(Object fieldValue) {
        return this.mIndexMap.containsKey(fieldValue);
    }

    @Override
    public boolean containsObject(T object) {
        Object fieldValue = this.mIndexDefinition.getFieldValue(object);
        Object res = this.mIndexMap.get(fieldValue);
        if (res == null) {
            return false;
        }
        return res == object;
    }

    @Override
    public Set<T> getByField(Object value) {
        Object res = this.mIndexMap.get(value);
        if (res != null) {
            return Collections.singleton(res);
        }
        return Collections.emptySet();
    }

    @Override
    public T getFirst(Object value) {
        return (T)this.mIndexMap.get(value);
    }

    @Override
    public Iterator<T> iterator() {
        return this.mIndexMap.values().iterator();
    }

    @Override
    public int size() {
        return this.mIndexMap.size();
    }
}

