/*
 * Decompiled with CFR 0.152.
 */
package alluxio.exception;

import alluxio.exception.AccessControlException;
import alluxio.exception.BlockAlreadyExistsException;
import alluxio.exception.BlockDoesNotExistException;
import alluxio.exception.BlockInfoException;
import alluxio.exception.ConnectionFailedException;
import alluxio.exception.DependencyDoesNotExistException;
import alluxio.exception.DirectoryNotEmptyException;
import alluxio.exception.FailedToCheckpointException;
import alluxio.exception.FileAlreadyCompletedException;
import alluxio.exception.FileAlreadyExistsException;
import alluxio.exception.FileDoesNotExistException;
import alluxio.exception.InvalidFileSizeException;
import alluxio.exception.InvalidPathException;
import alluxio.exception.InvalidWorkerStateException;
import alluxio.exception.LineageDeletionException;
import alluxio.exception.LineageDoesNotExistException;
import alluxio.exception.NoWorkerException;
import alluxio.exception.WorkerOutOfSpaceException;
import alluxio.thrift.AlluxioTException;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class AlluxioException
extends Exception {
    private static final long serialVersionUID = 2243833925609642384L;

    protected AlluxioException(AlluxioTException te) {
        super(te.getMessage());
    }

    protected AlluxioException(Throwable cause) {
        super(cause);
    }

    protected AlluxioException(String message) {
        super(message);
    }

    protected AlluxioException(String message, Throwable cause) {
        super(message, cause);
    }

    public AlluxioTException toThrift() {
        return new AlluxioTException(AlluxioExceptionType.getAlluxioExceptionType(this.getClass()), this.getMessage(), this.getClass().getName());
    }

    public static AlluxioException fromThrift(AlluxioTException e) {
        try {
            Class<Object> throwClass = e.isSetClassName() ? Class.forName(e.getClassName()) : AlluxioExceptionType.getAlluxioExceptionClass(e.getType());
            if (throwClass == null) {
                throwClass = AlluxioException.class;
            }
            return (AlluxioException)throwClass.getConstructor(String.class).newInstance(e.getMessage());
        }
        catch (ReflectiveOperationException reflectException) {
            String errorMessage = "Could not instantiate " + e.getType() + " with a String-only " + "constructor: " + reflectException.getMessage();
            throw new IllegalStateException(errorMessage, reflectException);
        }
    }

    @Deprecated
    @ThreadSafe
    private static enum AlluxioExceptionType {
        ACCESS_CONTROL(AccessControlException.class),
        BLOCK_ALREADY_EXISTS(BlockAlreadyExistsException.class),
        BLOCK_DOES_NOT_EXIST(BlockDoesNotExistException.class),
        BLOCK_INFO(BlockInfoException.class),
        CONNECTION_FAILED(ConnectionFailedException.class),
        DEPENDENCY_DOES_NOT_EXIST(DependencyDoesNotExistException.class),
        DIRECTORY_NOT_EMPTY_EXCEPTION(DirectoryNotEmptyException.class),
        FAILED_TO_CHECKPOINT(FailedToCheckpointException.class),
        FILE_ALREADY_COMPLETED(FileAlreadyCompletedException.class),
        FILE_ALREADY_EXISTS(FileAlreadyExistsException.class),
        FILE_DOES_NOT_EXIST(FileDoesNotExistException.class),
        INVALID_FILE_SIZE(InvalidFileSizeException.class),
        INVALID_PATH(InvalidPathException.class),
        INVALID_WORKER_STATE(InvalidWorkerStateException.class),
        LINEAGE_DELETION(LineageDeletionException.class),
        LINEAGE_DOES_NOT_EXIST(LineageDoesNotExistException.class),
        NO_WORKER(NoWorkerException.class),
        WORKER_OUT_OF_SPACE(WorkerOutOfSpaceException.class);

        private final Class<? extends AlluxioException> mExceptionClass;

        private AlluxioExceptionType(Class<? extends AlluxioException> exceptionClass) {
            this.mExceptionClass = exceptionClass;
        }

        static Class<? extends AlluxioException> getAlluxioExceptionClass(String text) {
            if (text != null) {
                for (AlluxioExceptionType t : AlluxioExceptionType.values()) {
                    if (!text.equalsIgnoreCase(t.name())) continue;
                    return t.mExceptionClass;
                }
            }
            return null;
        }

        static String getAlluxioExceptionType(Class<? extends AlluxioException> e) {
            if (e != null) {
                for (AlluxioExceptionType t : AlluxioExceptionType.values()) {
                    if (!t.mExceptionClass.equals(e)) continue;
                    return t.name();
                }
            }
            return null;
        }
    }
}

