/*
 * Decompiled with CFR 0.152.
 */
package alluxio.heartbeat;

import alluxio.heartbeat.ScheduledTimer;
import alluxio.resource.LockResource;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class HeartbeatScheduler {
    private static Map<String, ScheduledTimer> sTimers = new HashMap<String, ScheduledTimer>();
    private static Lock sLock = new ReentrantLock();
    private static Condition sCondition = sLock.newCondition();

    private HeartbeatScheduler() {
    }

    public static void addTimer(ScheduledTimer timer) {
        Preconditions.checkNotNull((Object)timer, (Object)"timer");
        try (LockResource r = new LockResource(sLock);){
            Preconditions.checkState((!sTimers.containsKey(timer.getThreadName()) ? 1 : 0) != 0, (String)"The timer for thread %s is already waiting to be scheduled", (Object[])new Object[]{timer.getThreadName()});
            sTimers.put(timer.getThreadName(), timer);
            sCondition.signalAll();
        }
    }

    public static void clearTimer(String name) {
        try (LockResource r = new LockResource(sLock);){
            sTimers.remove(name);
        }
    }

    public static void removeTimer(ScheduledTimer timer) {
        Preconditions.checkNotNull((Object)timer, (Object)"timer");
        try (LockResource r = new LockResource(sLock);){
            ScheduledTimer removedTimer = sTimers.remove(timer.getThreadName());
            Preconditions.checkNotNull((Object)removedTimer, (String)"sTimers should contain %s", (Object[])new Object[]{timer.getThreadName()});
            Preconditions.checkState((removedTimer == timer ? 1 : 0) != 0, (Object)"sTimers should contain the timer being removed");
        }
    }

    public static Set<String> getThreadNames() {
        try (LockResource r = new LockResource(sLock);){
            Set<String> set = sTimers.keySet();
            return set;
        }
    }

    public static void schedule(String threadName) {
        try (LockResource r = new LockResource(sLock);){
            ScheduledTimer timer = sTimers.get(threadName);
            if (timer == null) {
                throw new RuntimeException("Timer for thread " + threadName + " not found.");
            }
            timer.schedule();
        }
    }

    public static void await(String name) throws InterruptedException {
        try (LockResource r = new LockResource(sLock);){
            while (!sTimers.containsKey(name)) {
                sCondition.await();
            }
        }
    }

    public static void await(String name, long time, TimeUnit unit) throws InterruptedException {
        try (LockResource r = new LockResource(sLock);){
            while (!sTimers.containsKey(name)) {
                if (sCondition.await(time, unit)) continue;
                throw new RuntimeException("Timed out waiting for thread " + name + " to be ready for scheduling");
            }
        }
    }

    public static void execute(String name) throws InterruptedException {
        HeartbeatScheduler.await(name);
        HeartbeatScheduler.schedule(name);
        HeartbeatScheduler.await(name);
    }
}

