/*
 * Decompiled with CFR 0.152.
 */
package alluxio.heartbeat;

import alluxio.heartbeat.HeartbeatContext;
import alluxio.heartbeat.HeartbeatExecutor;
import alluxio.heartbeat.HeartbeatTimer;
import alluxio.heartbeat.SleepingTimer;
import alluxio.security.LoginUser;
import alluxio.security.authentication.AuthenticatedClientUser;
import alluxio.util.CommonUtils;
import alluxio.util.SecurityUtils;
import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class HeartbeatThread
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private final String mThreadName;
    private final HeartbeatExecutor mExecutor;
    private HeartbeatTimer mTimer;

    public HeartbeatThread(String threadName, HeartbeatExecutor executor, long intervalMs) {
        this.mThreadName = threadName;
        this.mExecutor = (HeartbeatExecutor)Preconditions.checkNotNull((Object)executor, (Object)"executor");
        Class<? extends HeartbeatTimer> timerClass = HeartbeatContext.getTimerClass(threadName);
        try {
            this.mTimer = CommonUtils.createNewClassInstance(timerClass, new Class[]{String.class, Long.TYPE}, new Object[]{threadName, intervalMs});
        }
        catch (Exception e) {
            String msg = "timer class could not be instantiated";
            LOG.error("{} : {} , {}", new Object[]{msg, threadName, e});
            this.mTimer = new SleepingTimer(threadName, intervalMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (SecurityUtils.isSecurityEnabled() && AuthenticatedClientUser.get() == null) {
                AuthenticatedClientUser.set(LoginUser.get().getName());
            }
        }
        catch (IOException e) {
            LOG.error("Failed to set AuthenticatedClientUser in HeartbeatThread.");
        }
        Thread.currentThread().setName(this.mThreadName);
        try {
            while (!Thread.interrupted()) {
                this.mTimer.tick();
                this.mExecutor.heartbeat();
            }
        }
        catch (InterruptedException e) {
            LOG.info("Hearbeat is interrupted.");
        }
        catch (Exception e) {
            LOG.error("Uncaught exception in heartbeat executor, Heartbeat Thread shutting down", (Throwable)e);
        }
        finally {
            this.mExecutor.close();
        }
    }
}

