/*
 * Decompiled with CFR 0.152.
 */
package alluxio.heartbeat;

import alluxio.clock.Clock;
import alluxio.clock.SystemClock;
import alluxio.heartbeat.HeartbeatTimer;
import alluxio.time.Sleeper;
import alluxio.time.ThreadSleeper;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class SleepingTimer
implements HeartbeatTimer {
    private final long mIntervalMs;
    private long mPreviousTickMs;
    private final String mThreadName;
    private final Logger mLogger;
    private final Clock mClock;
    private final Sleeper mSleeper;

    public SleepingTimer(String threadName, long intervalMs) {
        this(threadName, intervalMs, LoggerFactory.getLogger((String)"alluxio.logger.type"), new SystemClock(), new ThreadSleeper());
    }

    public SleepingTimer(String threadName, long intervalMs, Logger logger, Clock clock, Sleeper sleeper) {
        this.mIntervalMs = intervalMs;
        this.mThreadName = threadName;
        this.mLogger = logger;
        this.mClock = clock;
        this.mSleeper = sleeper;
    }

    @Override
    public void tick() throws InterruptedException {
        if (this.mPreviousTickMs != 0L) {
            long executionTimeMs = this.mClock.millis() - this.mPreviousTickMs;
            if (executionTimeMs > this.mIntervalMs) {
                this.mLogger.warn("{} last execution took {} ms. Longer than the interval {}", new Object[]{this.mThreadName, executionTimeMs, this.mIntervalMs});
            } else {
                this.mSleeper.sleep(this.mIntervalMs - executionTimeMs);
            }
        }
        this.mPreviousTickMs = this.mClock.millis();
    }
}

