/*
 * Decompiled with CFR 0.152.
 */
package alluxio.metrics;

import alluxio.Configuration;
import alluxio.PropertyKey;
import alluxio.metrics.MetricsConfig;
import alluxio.metrics.sink.Sink;
import alluxio.util.network.NetworkAddressUtils;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.Timer;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class MetricsSystem {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    public static final String MASTER_INSTANCE = "master";
    public static final String WORKER_INSTANCE = "worker";
    public static final String CLIENT_INSTANCE = "client";
    public static final MetricRegistry METRIC_REGISTRY = new MetricRegistry();
    @GuardedBy(value="MetricsSystem")
    private static List<Sink> sSinks;
    public static final String SINK_REGEX = "^sink\\.(.+)\\.(.+)";
    private static final TimeUnit MINIMAL_POLL_UNIT;
    private static final int MINIMAL_POLL_PERIOD = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startSinks() {
        Class<MetricsSystem> clazz = MetricsSystem.class;
        synchronized (MetricsSystem.class) {
            if (sSinks != null) {
                LOG.info("Sinks have already been started.");
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            String metricsConfFile = Configuration.get(PropertyKey.METRICS_CONF_FILE);
            if (metricsConfFile.isEmpty()) {
                LOG.info("Metrics is not enabled.");
                return;
            }
            MetricsConfig config = new MetricsConfig(metricsConfFile);
            MetricsSystem.startSinksFromConfig(config);
            return;
        }
    }

    public static synchronized void startSinksFromConfig(MetricsConfig config) {
        if (sSinks != null) {
            LOG.info("Sinks have already been started.");
            return;
        }
        LOG.info("Starting sinks with config: {}.", (Object)config);
        sSinks = new ArrayList<Sink>();
        Map<String, Properties> sinkConfigs = MetricsConfig.subProperties(config.getProperties(), SINK_REGEX);
        for (Map.Entry<String, Properties> entry : sinkConfigs.entrySet()) {
            String classPath = entry.getValue().getProperty("class");
            if (classPath == null) continue;
            LOG.info("Starting sink {}.", (Object)classPath);
            try {
                Sink sink = (Sink)Class.forName(classPath).getConstructor(Properties.class, MetricRegistry.class).newInstance(entry.getValue(), METRIC_REGISTRY);
                sink.start();
                sSinks.add(sink);
            }
            catch (Exception e) {
                LOG.error("Sink class {} cannot be instantiated", (Object)classPath, (Object)e);
            }
        }
    }

    public static synchronized void stopSinks() {
        if (sSinks != null) {
            for (Sink sink : sSinks) {
                sink.stop();
            }
        }
        sSinks = null;
    }

    public static synchronized int getNumSinks() {
        int sz = 0;
        if (sSinks != null) {
            sz = sSinks.size();
        }
        return sz;
    }

    public static String getMasterMetricName(String name) {
        return Joiner.on((String)".").join((Object)MASTER_INSTANCE, (Object)name, new Object[0]);
    }

    public static String getWorkerMetricName(String name) {
        return MetricsSystem.getMetricNameWithUniqueId(WORKER_INSTANCE, name);
    }

    public static String getClientMetricName(String name) {
        return MetricsSystem.getMetricNameWithUniqueId(CLIENT_INSTANCE, name);
    }

    public static String getMetricNameWithUniqueId(String instance, String name) {
        return Joiner.on((String)".").join((Object)instance, (Object)NetworkAddressUtils.getLocalHostName().replace('.', '_'), new Object[]{name});
    }

    public static void checkMinimalPollingPeriod(TimeUnit pollUnit, int pollPeriod) throws IllegalArgumentException {
        int period = (int)MINIMAL_POLL_UNIT.convert(pollPeriod, pollUnit);
        Preconditions.checkArgument((period >= 1 ? 1 : 0) != 0, (String)"Polling period %d %d is below than minimal polling period", (Object[])new Object[]{pollPeriod, pollUnit});
    }

    public static String stripInstanceAndHost(String metricsName) {
        Object[] pieces = metricsName.split("\\.");
        Preconditions.checkArgument((pieces.length > 1 ? 1 : 0) != 0, (String)"Incorrect metrics name: %s.", (Object[])new Object[]{metricsName});
        if (!pieces[0].equals(MASTER_INSTANCE)) {
            pieces[1] = null;
        }
        pieces[0] = null;
        return Joiner.on((String)".").skipNulls().join(pieces);
    }

    public static Timer masterTimer(String name) {
        return METRIC_REGISTRY.timer(MetricsSystem.getMasterMetricName(name));
    }

    public static Counter masterCounter(String name) {
        return METRIC_REGISTRY.counter(MetricsSystem.getMasterMetricName(name));
    }

    public static Timer workerTimer(String name) {
        return METRIC_REGISTRY.timer(MetricsSystem.getWorkerMetricName(name));
    }

    public static Counter workerCounter(String name) {
        return METRIC_REGISTRY.counter(MetricsSystem.getWorkerMetricName(name));
    }

    public static Timer clientTimer(String name) {
        return METRIC_REGISTRY.timer(MetricsSystem.getClientMetricName(name));
    }

    public static Counter clientCounter(String name) {
        return METRIC_REGISTRY.counter(MetricsSystem.getClientMetricName(name));
    }

    public static synchronized <T> void registerGaugeIfAbsent(String name, Gauge<T> metric) {
        if (!METRIC_REGISTRY.getGauges().containsKey(name)) {
            METRIC_REGISTRY.register(name, metric);
        }
    }

    public static void resetAllCounters() {
        for (Map.Entry entry : METRIC_REGISTRY.getCounters().entrySet()) {
            ((Counter)entry.getValue()).dec(((Counter)entry.getValue()).getCount());
        }
    }

    private MetricsSystem() {
    }

    static {
        METRIC_REGISTRY.registerAll((MetricSet)new GarbageCollectorMetricSet());
        METRIC_REGISTRY.registerAll((MetricSet)new MemoryUsageGaugeSet());
        MINIMAL_POLL_UNIT = TimeUnit.SECONDS;
    }
}

