/*
 * Decompiled with CFR 0.152.
 */
package alluxio.metrics.sink;

import alluxio.metrics.MetricsSystem;
import alluxio.metrics.sink.Sink;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ganglia.GangliaReporter;
import info.ganglia.gmetric4j.gmetric.GMetric;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class GangliaSink
implements Sink {
    private static final String GANGLIA_DEFAULT_PORT = "8649";
    private static final int GANGLIA_DEFAULT_PERIOD = 10;
    private static final String GANGLIA_DEFAULT_UNIT = "SECONDS";
    private static final String GANGLIA_DEFAULT_TTL = "1";
    private static final String GANGLIA_KEY_HOST = "host";
    private static final String GANGLIA_KEY_PORT = "port";
    private static final String GANGLIA_KEY_PERIOD = "period";
    private static final String GANGLIA_KEY_UNIT = "unit";
    private static final String GANGLIA_KEY_TTL = "ttl";
    private GangliaReporter mReporter;
    private Properties mProperties;

    public GangliaSink(Properties properties, MetricRegistry registry) throws IllegalArgumentException, IOException {
        String ttl;
        this.mProperties = properties;
        String host = properties.getProperty(GANGLIA_KEY_HOST);
        if (host == null) {
            throw new IllegalArgumentException("Ganglia sink requires 'host' properties");
        }
        String port = properties.getProperty(GANGLIA_KEY_PORT);
        if (port == null) {
            port = GANGLIA_DEFAULT_PORT;
        }
        if ((ttl = properties.getProperty(GANGLIA_KEY_TTL)) == null) {
            ttl = GANGLIA_DEFAULT_TTL;
        }
        GMetric ganglia = new GMetric(host, Integer.parseInt(port), GMetric.UDPAddressingMode.MULTICAST, Integer.parseInt(ttl));
        this.mReporter = GangliaReporter.forRegistry((MetricRegistry)registry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build(ganglia);
        MetricsSystem.checkMinimalPollingPeriod(this.getPollUnit(), this.getPollPeriod());
    }

    @Override
    public void start() {
        this.mReporter.start((long)this.getPollPeriod(), this.getPollUnit());
    }

    @Override
    public void stop() {
        this.mReporter.stop();
    }

    @Override
    public void report() {
        this.mReporter.report();
    }

    private int getPollPeriod() {
        String period = this.mProperties.getProperty(GANGLIA_KEY_PERIOD);
        return period != null ? Integer.parseInt(period) : 10;
    }

    private TimeUnit getPollUnit() {
        String unit = this.mProperties.getProperty(GANGLIA_KEY_UNIT);
        if (unit == null) {
            unit = GANGLIA_DEFAULT_UNIT;
        }
        return TimeUnit.valueOf(unit.toUpperCase());
    }
}

