/*
 * Decompiled with CFR 0.152.
 */
package alluxio.network.connection;

import alluxio.Configuration;
import alluxio.PropertyKey;
import alluxio.resource.DynamicResourcePool;
import alluxio.util.ThreadFactoryUtils;
import com.google.common.base.Throwables;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class NettyChannelPool
extends DynamicResourcePool<Channel> {
    private static final int NETTY_CHANNEL_POOL_GC_THREADPOOL_SIZE = 10;
    private static final ScheduledExecutorService GC_EXECUTOR = new ScheduledThreadPoolExecutor(10, ThreadFactoryUtils.build("NettyChannelPoolGcThreads-%d", true));
    private static final boolean POOL_DISABLED = Configuration.getBoolean(PropertyKey.USER_NETWORK_NETTY_CHANNEL_POOL_DISABLED);
    private final Bootstrap mBootstrap;
    private final long mGcThresholdMs;

    public NettyChannelPool(Bootstrap bootstrap, int maxCapacity, long gcThresholdMs) {
        super(DynamicResourcePool.Options.defaultOptions().setMaxCapacity(maxCapacity).setGcExecutor(GC_EXECUTOR));
        this.mBootstrap = bootstrap;
        this.mGcThresholdMs = gcThresholdMs;
    }

    @Override
    protected void closeResource(Channel channel) {
        LOG.info("Channel closed");
        channel.close();
    }

    @Override
    protected void closeResourceSync(Channel channel) {
        LOG.info("Channel closed synchronously.");
        channel.close().syncUninterruptibly();
    }

    @Override
    protected Channel createNewResource() throws IOException {
        Bootstrap bs;
        try {
            bs = this.mBootstrap.clone();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        try {
            ChannelFuture channelFuture = bs.connect().sync();
            if (channelFuture.isSuccess()) {
                LOG.info("Created netty channel with netty bootstrap {}.", (Object)this.mBootstrap);
                return channelFuture.channel();
            }
            LOG.error("Failed to create netty channel with netty bootstrap {} and error {}.", (Object)this.mBootstrap, (Object)channelFuture.cause().getMessage());
            throw new IOException(channelFuture.cause());
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected boolean isHealthy(Channel channel) {
        if (POOL_DISABLED) {
            return false;
        }
        return channel.isActive();
    }

    @Override
    protected boolean shouldGc(DynamicResourcePool.ResourceInternal<Channel> channelResourceInternal) {
        return System.currentTimeMillis() - channelResourceInternal.getLastAccessTimeMs() > this.mGcThresholdMs;
    }
}

