/*
 * Decompiled with CFR 0.152.
 */
package alluxio.network.connection;

import alluxio.RuntimeConstants;
import alluxio.exception.ExceptionMessage;
import alluxio.resource.DynamicResourcePool;
import alluxio.retry.ExponentialBackoffRetry;
import alluxio.security.authentication.TransportProvider;
import alluxio.thrift.AlluxioService;
import alluxio.util.ThreadFactoryUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.regex.Pattern;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.security.auth.Subject;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TMultiplexedProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

@ThreadSafe
public abstract class ThriftClientPool<T extends AlluxioService.Client>
extends DynamicResourcePool<T> {
    private final TransportProvider mTransportProvider = TransportProvider.Factory.create();
    private final String mServiceName;
    private final long mServiceVersion;
    private final InetSocketAddress mAddress;
    private final long mGcThresholdMs;
    private final Subject mParentSubject;
    private static final int THRIFT_CLIENT_POOL_GC_THREADPOOL_SIZE = 5;
    private static final ScheduledExecutorService GC_EXECUTOR = new ScheduledThreadPoolExecutor(5, ThreadFactoryUtils.build("ThriftClientPoolGcThreads-%d", true));
    @GuardedBy(value="this")
    private Long mServerVersionFound = null;
    private static final int CONNECTION_OPEN_RETRY_BASE_SLEEP_MS = 50;
    private static final int CONNECTION_OPEN_RETRY_MAX = 5;
    private static final Pattern FRAME_SIZE_TOO_LARGE_EXCEPTION_PATTERN = Pattern.compile("Frame size \\((\\d+)\\) larger than max length");
    private static final Pattern FRAME_SIZE_NEGATIVE_EXCEPTION_PATTERN = Pattern.compile("Read a negative frame size");

    public ThriftClientPool(Subject subject, String serviceName, long serviceVersion, InetSocketAddress address, int maxCapacity, long gcThresholdMs) {
        super(DynamicResourcePool.Options.defaultOptions().setMaxCapacity(maxCapacity).setGcExecutor(GC_EXECUTOR));
        this.mServiceName = serviceName;
        this.mServiceVersion = serviceVersion;
        this.mAddress = address;
        this.mGcThresholdMs = gcThresholdMs;
        this.mParentSubject = subject;
    }

    public static <C extends AlluxioService.Client> void closeThriftClient(C client) {
        TTransport transport = client.getOutputProtocol().getTransport();
        if (transport.isOpen()) {
            transport.close();
        }
    }

    @Override
    protected void closeResource(T client) {
        ThriftClientPool.closeThriftClient(client);
    }

    @Override
    protected void closeResourceSync(T client) {
        this.closeResource(client);
    }

    @Override
    protected T createNewResource() throws IOException {
        T client;
        block5: {
            TTransport transport = this.mTransportProvider.getClientTransport(this.mParentSubject, this.mAddress);
            TBinaryProtocol binaryProtocol = new TBinaryProtocol(transport);
            client = this.createThriftClient((TProtocol)new TMultiplexedProtocol((TProtocol)binaryProtocol, this.mServiceName));
            ExponentialBackoffRetry retry = new ExponentialBackoffRetry(50, 1000, 5);
            try {
                if (!transport.isOpen()) {
                    transport.open();
                }
                if (transport.isOpen()) {
                    this.checkVersion(client);
                }
            }
            catch (TTransportException e) {
                LOG.error("Failed to connect (" + retry.getRetryCount() + ") to " + this.getServiceNameForLogging() + " @ " + this.mAddress, (Throwable)e);
                if (e.getCause() instanceof SocketTimeoutException) {
                    String message = "Thrift transport open times out. Please check whether the authentication types match between client and server. Note that NOSASL client is not able to connect to servers with SIMPLE security mode.";
                    throw new IOException(message, e);
                }
                if (retry.attemptRetry()) break block5;
                throw new IOException(e);
            }
        }
        LOG.info("Created a new thrift client {}", (Object)client.toString());
        return client;
    }

    @Override
    protected boolean isHealthy(T client) {
        return client.getOutputProtocol().getTransport().isOpen();
    }

    @Override
    protected boolean shouldGc(DynamicResourcePool.ResourceInternal<T> clientResourceInternal) {
        return System.currentTimeMillis() - clientResourceInternal.getLastAccessTimeMs() > this.mGcThresholdMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkVersion(T client) throws TTransportException, IOException {
        ThriftClientPool thriftClientPool = this;
        synchronized (thriftClientPool) {
            if (this.mServerVersionFound != null) {
                if (this.mServerVersionFound != this.mServiceVersion) {
                    throw new IOException(ExceptionMessage.INCOMPATIBLE_VERSION.getMessage(this.mServiceName, this.mServiceVersion, this.mServerVersionFound));
                }
                return;
            }
        }
        try {
            long serviceVersionFound = ((AlluxioService.Client)client).getServiceVersion();
            ThriftClientPool thriftClientPool2 = this;
            synchronized (thriftClientPool2) {
                this.mServerVersionFound = serviceVersionFound;
                if (this.mServerVersionFound != this.mServiceVersion) {
                    throw new IOException(ExceptionMessage.INCOMPATIBLE_VERSION.getMessage(this.mServiceName, this.mServiceVersion, this.mServerVersionFound));
                }
            }
        }
        catch (TTransportException e) {
            this.closeResource(client);
            if (e.getMessage() != null && (FRAME_SIZE_NEGATIVE_EXCEPTION_PATTERN.matcher(e.getMessage()).find() || FRAME_SIZE_TOO_LARGE_EXCEPTION_PATTERN.matcher(e.getMessage()).find())) {
                String message = String.format("Failed to connect to %s @ %s: %s. This exception may be caused by incorrect network configuration. Please consult %s for common solutions to address this problem.", this.getServiceNameForLogging(), this.mAddress, e.getMessage(), RuntimeConstants.ALLUXIO_DEBUG_DOCS_URL);
                throw new IOException(message, e);
            }
            throw e;
        }
        catch (TException e) {
            this.closeResource(client);
            throw new IOException(e);
        }
    }

    protected abstract T createThriftClient(TProtocol var1);

    protected String getServiceNameForLogging() {
        return this.mServiceName;
    }
}

