/*
 * Decompiled with CFR 0.152.
 */
package alluxio.network.protocol;

import alluxio.network.protocol.RPCMessage;
import alluxio.network.protocol.RPCRequest;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class RPCBlockReadRequest
extends RPCRequest {
    private final long mBlockId;
    private final long mOffset;
    private final long mLength;
    private final long mLockId;
    private final long mSessionId;

    public RPCBlockReadRequest(long blockId, long offset, long length, long lockId, long sessionId) {
        this.mBlockId = blockId;
        this.mOffset = offset;
        this.mLength = length;
        this.mLockId = lockId;
        this.mSessionId = sessionId;
    }

    @Override
    public RPCMessage.Type getType() {
        return RPCMessage.Type.RPC_BLOCK_READ_REQUEST;
    }

    public static RPCBlockReadRequest decode(ByteBuf in) {
        long blockId = in.readLong();
        long offset = in.readLong();
        long length = in.readLong();
        long lockId = in.readLong();
        long sessionId = in.readLong();
        return new RPCBlockReadRequest(blockId, offset, length, lockId, sessionId);
    }

    @Override
    public int getEncodedLength() {
        return 40;
    }

    @Override
    public void encode(ByteBuf out) {
        out.writeLong(this.mBlockId);
        out.writeLong(this.mOffset);
        out.writeLong(this.mLength);
        out.writeLong(this.mLockId);
        out.writeLong(this.mSessionId);
    }

    @Override
    public void validate() {
        Preconditions.checkState((this.mOffset >= 0L ? 1 : 0) != 0, (String)"Offset cannot be negative: %s", (Object[])new Object[]{this.mOffset});
        Preconditions.checkState((this.mLength >= 0L || this.mLength == -1L ? 1 : 0) != 0, (String)"Length cannot be negative (except for -1): %s", (Object[])new Object[]{this.mLength});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("blockId", this.mBlockId).add("offset", this.mOffset).add("length", this.mLength).add("lockId", this.mLockId).add("sessionId", this.mSessionId).toString();
    }

    public long getBlockId() {
        return this.mBlockId;
    }

    public long getLength() {
        return this.mLength;
    }

    public long getOffset() {
        return this.mOffset;
    }

    public long getLockId() {
        return this.mLockId;
    }

    public long getSessionId() {
        return this.mSessionId;
    }
}

