/*
 * Decompiled with CFR 0.152.
 */
package alluxio.network.protocol;

import alluxio.network.protocol.RPCBlockReadRequest;
import alluxio.network.protocol.RPCMessage;
import alluxio.network.protocol.RPCResponse;
import alluxio.network.protocol.databuffer.DataBuffer;
import alluxio.network.protocol.databuffer.DataNettyBuffer;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class RPCBlockReadResponse
extends RPCResponse {
    private final long mBlockId;
    private final long mOffset;
    private final long mLength;
    private final DataBuffer mData;
    private final RPCResponse.Status mStatus;

    public RPCBlockReadResponse(long blockId, long offset, long length, DataBuffer data, RPCResponse.Status status) {
        this.mBlockId = blockId;
        this.mOffset = offset;
        this.mLength = length;
        this.mData = data;
        this.mStatus = status;
    }

    @Override
    public RPCMessage.Type getType() {
        return RPCMessage.Type.RPC_BLOCK_READ_RESPONSE;
    }

    public static RPCBlockReadResponse createErrorResponse(RPCBlockReadRequest request, RPCResponse.Status status) {
        Preconditions.checkArgument((status != RPCResponse.Status.SUCCESS ? 1 : 0) != 0);
        return new RPCBlockReadResponse(request.getBlockId(), request.getOffset(), 0L, null, status);
    }

    public static RPCBlockReadResponse decode(ByteBuf in) {
        long blockId = in.readLong();
        long offset = in.readLong();
        long length = in.readLong();
        short status = in.readShort();
        DataNettyBuffer data = null;
        if (length > 0L) {
            data = new DataNettyBuffer(in, (int)length);
        }
        return new RPCBlockReadResponse(blockId, offset, length, data, RPCResponse.Status.fromShort(status));
    }

    @Override
    public int getEncodedLength() {
        return 26;
    }

    @Override
    public void encode(ByteBuf out) {
        out.writeLong(this.mBlockId);
        out.writeLong(this.mOffset);
        out.writeLong(this.mLength);
        out.writeShort((int)this.mStatus.getId());
    }

    @Override
    public DataBuffer getPayloadDataBuffer() {
        return this.mData;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("blockId", this.mBlockId).add("offset", this.mOffset).add("length", this.mLength).add("status", (Object)this.mStatus).toString();
    }

    public long getBlockId() {
        return this.mBlockId;
    }

    public long getLength() {
        return this.mLength;
    }

    public long getOffset() {
        return this.mOffset;
    }

    @Override
    public RPCResponse.Status getStatus() {
        return this.mStatus;
    }
}

