/*
 * Decompiled with CFR 0.152.
 */
package alluxio.network.protocol;

import alluxio.network.protocol.RPCBlockWriteRequest;
import alluxio.network.protocol.RPCMessage;
import alluxio.network.protocol.RPCResponse;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class RPCBlockWriteResponse
extends RPCResponse {
    private final long mSessionId;
    private final long mBlockId;
    private final long mOffset;
    private final long mLength;
    private final RPCResponse.Status mStatus;

    public RPCBlockWriteResponse(long sessionId, long blockId, long offset, long length, RPCResponse.Status status) {
        this.mSessionId = sessionId;
        this.mBlockId = blockId;
        this.mOffset = offset;
        this.mLength = length;
        this.mStatus = status;
    }

    public static RPCBlockWriteResponse createErrorResponse(RPCBlockWriteRequest request, RPCResponse.Status status) {
        Preconditions.checkArgument((status != RPCResponse.Status.SUCCESS ? 1 : 0) != 0);
        return new RPCBlockWriteResponse(request.getSessionId(), request.getBlockId(), request.getOffset(), request.getLength(), status);
    }

    @Override
    public RPCMessage.Type getType() {
        return RPCMessage.Type.RPC_BLOCK_WRITE_RESPONSE;
    }

    public static RPCBlockWriteResponse decode(ByteBuf in) {
        long sessionId = in.readLong();
        long blockId = in.readLong();
        long offset = in.readLong();
        long length = in.readLong();
        short status = in.readShort();
        return new RPCBlockWriteResponse(sessionId, blockId, offset, length, RPCResponse.Status.fromShort(status));
    }

    @Override
    public int getEncodedLength() {
        return 34;
    }

    @Override
    public void encode(ByteBuf out) {
        out.writeLong(this.mSessionId);
        out.writeLong(this.mBlockId);
        out.writeLong(this.mOffset);
        out.writeLong(this.mLength);
        out.writeShort((int)this.mStatus.getId());
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("blockId", this.mBlockId).add("offset", this.mOffset).add("length", this.mLength).add("sessionId", this.mSessionId).add("status", (Object)this.mStatus).toString();
    }

    public long getSessionId() {
        return this.mSessionId;
    }

    public long getBlockId() {
        return this.mBlockId;
    }

    public long getLength() {
        return this.mLength;
    }

    public long getOffset() {
        return this.mOffset;
    }

    @Override
    public RPCResponse.Status getStatus() {
        return this.mStatus;
    }
}

