/*
 * Decompiled with CFR 0.152.
 */
package alluxio.network.protocol;

import alluxio.network.protocol.RPCMessage;
import alluxio.network.protocol.RPCResponse;
import com.google.common.base.Objects;
import io.netty.buffer.ByteBuf;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class RPCErrorResponse
extends RPCResponse {
    private final RPCResponse.Status mStatus;

    public RPCErrorResponse(RPCResponse.Status status) {
        this.mStatus = status;
    }

    public static RPCErrorResponse decode(ByteBuf in) {
        return new RPCErrorResponse(RPCResponse.Status.fromShort(in.readShort()));
    }

    @Override
    public void encode(ByteBuf out) {
        out.writeShort((int)this.mStatus.getId());
    }

    @Override
    public int getEncodedLength() {
        return 2;
    }

    @Override
    public RPCResponse.Status getStatus() {
        return this.mStatus;
    }

    @Override
    public RPCMessage.Type getType() {
        return RPCMessage.Type.RPC_ERROR_RESPONSE;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("status", (Object)this.mStatus).toString();
    }
}

