/*
 * Decompiled with CFR 0.152.
 */
package alluxio.network.protocol;

import alluxio.network.protocol.RPCMessage;
import alluxio.network.protocol.RPCRequest;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class RPCFileReadRequest
extends RPCRequest {
    private final long mTempUfsFileId;
    private final long mOffset;
    private final long mLength;

    public RPCFileReadRequest(long tempUfsFileId, long offset, long length) {
        this.mTempUfsFileId = tempUfsFileId;
        this.mOffset = offset;
        this.mLength = length;
    }

    @Override
    public RPCMessage.Type getType() {
        return RPCMessage.Type.RPC_FILE_READ_REQUEST;
    }

    public static RPCFileReadRequest decode(ByteBuf in) {
        long tempUfsFileId = in.readLong();
        long offset = in.readLong();
        long length = in.readLong();
        return new RPCFileReadRequest(tempUfsFileId, offset, length);
    }

    @Override
    public int getEncodedLength() {
        return 24;
    }

    @Override
    public void encode(ByteBuf out) {
        out.writeLong(this.mTempUfsFileId);
        out.writeLong(this.mOffset);
        out.writeLong(this.mLength);
    }

    @Override
    public void validate() {
        Preconditions.checkState((this.mOffset >= 0L ? 1 : 0) != 0, (String)"Offset cannot be negative: %s", (Object[])new Object[]{this.mOffset});
        Preconditions.checkState((this.mLength >= 0L ? 1 : 0) != 0, (String)"Length cannot be negative: %s", (Object[])new Object[]{this.mLength});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("tempUfsFileId", this.mTempUfsFileId).add("offset", this.mOffset).add("length", this.mLength).toString();
    }

    public long getTempUfsFileId() {
        return this.mTempUfsFileId;
    }

    public long getLength() {
        return this.mLength;
    }

    public long getOffset() {
        return this.mOffset;
    }
}

