/*
 * Decompiled with CFR 0.152.
 */
package alluxio.network.protocol;

import alluxio.network.protocol.RPCFileReadRequest;
import alluxio.network.protocol.RPCMessage;
import alluxio.network.protocol.RPCResponse;
import alluxio.network.protocol.databuffer.DataBuffer;
import alluxio.network.protocol.databuffer.DataNettyBuffer;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class RPCFileReadResponse
extends RPCResponse {
    private final long mTempUfsFileId;
    private final long mOffset;
    private final long mLength;
    private final DataBuffer mData;
    private final RPCResponse.Status mStatus;

    public RPCFileReadResponse(long tempUfsFileId, long offset, long length, DataBuffer data, RPCResponse.Status status) {
        this.mTempUfsFileId = tempUfsFileId;
        this.mOffset = offset;
        this.mLength = length;
        this.mData = data;
        this.mStatus = status;
    }

    @Override
    public RPCMessage.Type getType() {
        return RPCMessage.Type.RPC_FILE_READ_RESPONSE;
    }

    public static RPCFileReadResponse createErrorResponse(RPCFileReadRequest request, RPCResponse.Status status) {
        Preconditions.checkArgument((status != RPCResponse.Status.SUCCESS ? 1 : 0) != 0);
        return new RPCFileReadResponse(request.getTempUfsFileId(), request.getOffset(), 0L, null, status);
    }

    public static RPCFileReadResponse decode(ByteBuf in) {
        long tempUfsFileId = in.readLong();
        long offset = in.readLong();
        long length = in.readLong();
        short status = in.readShort();
        DataNettyBuffer data = null;
        if (length > 0L) {
            data = new DataNettyBuffer(in, (int)length);
        }
        return new RPCFileReadResponse(tempUfsFileId, offset, length, data, RPCResponse.Status.fromShort(status));
    }

    @Override
    public int getEncodedLength() {
        return 26;
    }

    @Override
    public void encode(ByteBuf out) {
        out.writeLong(this.mTempUfsFileId);
        out.writeLong(this.mOffset);
        out.writeLong(this.mLength);
        out.writeShort((int)this.mStatus.getId());
    }

    @Override
    public DataBuffer getPayloadDataBuffer() {
        return this.mData;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("tempUfsFileId", this.mTempUfsFileId).add("offset", this.mOffset).add("length", this.mLength).add("status", (Object)this.mStatus).toString();
    }

    @Override
    public void validate() {
        Preconditions.checkState((this.mOffset >= 0L ? 1 : 0) != 0, (String)"Offset cannot be negative: %s", (Object[])new Object[]{this.mOffset});
        Preconditions.checkState((this.mLength >= 0L ? 1 : 0) != 0, (String)"Length cannot be negative: %s", (Object[])new Object[]{this.mLength});
    }

    public long getTempUfsFileId() {
        return this.mTempUfsFileId;
    }

    public long getLength() {
        return this.mLength;
    }

    public long getOffset() {
        return this.mOffset;
    }

    @Override
    public RPCResponse.Status getStatus() {
        return this.mStatus;
    }

    public boolean isEOF() {
        return this.mLength == 0L;
    }
}

