/*
 * Decompiled with CFR 0.152.
 */
package alluxio.network.protocol;

import alluxio.network.protocol.RPCFileWriteRequest;
import alluxio.network.protocol.RPCMessage;
import alluxio.network.protocol.RPCResponse;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class RPCFileWriteResponse
extends RPCResponse {
    private final long mTempUfsFileId;
    private final long mOffset;
    private final long mLength;
    private final RPCResponse.Status mStatus;

    public RPCFileWriteResponse(long tempUfsFileId, long offset, long length, RPCResponse.Status status) {
        this.mTempUfsFileId = tempUfsFileId;
        this.mOffset = offset;
        this.mLength = length;
        this.mStatus = status;
    }

    public static RPCFileWriteResponse createErrorResponse(RPCFileWriteRequest request, RPCResponse.Status status) {
        Preconditions.checkArgument((status != RPCResponse.Status.SUCCESS ? 1 : 0) != 0);
        return new RPCFileWriteResponse(request.getTempUfsFileId(), request.getOffset(), request.getLength(), status);
    }

    @Override
    public RPCMessage.Type getType() {
        return RPCMessage.Type.RPC_FILE_WRITE_RESPONSE;
    }

    public static RPCFileWriteResponse decode(ByteBuf in) {
        long tempUfsFileId = in.readLong();
        long offset = in.readLong();
        long length = in.readLong();
        short status = in.readShort();
        return new RPCFileWriteResponse(tempUfsFileId, offset, length, RPCResponse.Status.fromShort(status));
    }

    @Override
    public int getEncodedLength() {
        return 26;
    }

    @Override
    public void encode(ByteBuf out) {
        out.writeLong(this.mTempUfsFileId);
        out.writeLong(this.mOffset);
        out.writeLong(this.mLength);
        out.writeShort((int)this.mStatus.getId());
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("tempUfsFileId", this.mTempUfsFileId).add("offset", this.mOffset).add("length", this.mLength).add("status", (Object)this.mStatus).toString();
    }

    @Override
    public void validate() {
        Preconditions.checkState((this.mOffset >= 0L ? 1 : 0) != 0, (String)"Offset cannot be negative: %s", (Object[])new Object[]{this.mOffset});
        Preconditions.checkState((this.mLength >= 0L || this.mLength == -1L ? 1 : 0) != 0, (String)"Length cannot be negative (except for -1): %s", (Object[])new Object[]{this.mLength});
    }

    public long getTempUfsFileId() {
        return this.mTempUfsFileId;
    }

    public long getLength() {
        return this.mLength;
    }

    public long getOffset() {
        return this.mOffset;
    }

    @Override
    public RPCResponse.Status getStatus() {
        return this.mStatus;
    }
}

