/*
 * Decompiled with CFR 0.152.
 */
package alluxio.network.protocol;

import alluxio.network.protocol.EncodedMessage;
import alluxio.network.protocol.RPCBlockReadRequest;
import alluxio.network.protocol.RPCBlockReadResponse;
import alluxio.network.protocol.RPCBlockWriteRequest;
import alluxio.network.protocol.RPCBlockWriteResponse;
import alluxio.network.protocol.RPCErrorResponse;
import alluxio.network.protocol.RPCFileReadRequest;
import alluxio.network.protocol.RPCFileReadResponse;
import alluxio.network.protocol.RPCFileWriteRequest;
import alluxio.network.protocol.RPCFileWriteResponse;
import alluxio.network.protocol.RPCProtoMessage;
import alluxio.network.protocol.databuffer.DataBuffer;
import alluxio.proto.dataserver.Protocol;
import com.google.protobuf.MessageLite;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class RPCMessage
implements EncodedMessage {
    public abstract Type getType();

    public void validate() {
    }

    public boolean hasPayload() {
        return this.getPayloadDataBuffer() != null;
    }

    public DataBuffer getPayloadDataBuffer() {
        return null;
    }

    public static ByteToMessageDecoder createFrameDecoder() {
        return new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 8, -8, 8);
    }

    public static RPCMessage decodeMessage(Type type, ByteBuf in) {
        switch (type) {
            case RPC_ERROR_RESPONSE: {
                return RPCErrorResponse.decode(in);
            }
            case RPC_BLOCK_READ_REQUEST: {
                return RPCBlockReadRequest.decode(in);
            }
            case RPC_BLOCK_READ_RESPONSE: {
                return RPCBlockReadResponse.decode(in);
            }
            case RPC_BLOCK_WRITE_REQUEST: {
                return RPCBlockWriteRequest.decode(in);
            }
            case RPC_BLOCK_WRITE_RESPONSE: {
                return RPCBlockWriteResponse.decode(in);
            }
            case RPC_FILE_READ_REQUEST: {
                return RPCFileReadRequest.decode(in);
            }
            case RPC_FILE_READ_RESPONSE: {
                return RPCFileReadResponse.decode(in);
            }
            case RPC_FILE_WRITE_REQUEST: {
                return RPCFileWriteRequest.decode(in);
            }
            case RPC_FILE_WRITE_RESPONSE: {
                return RPCFileWriteResponse.decode(in);
            }
            case RPC_READ_REQUEST: {
                return RPCProtoMessage.decode(in, (MessageLite)Protocol.ReadRequest.getDefaultInstance());
            }
            case RPC_WRITE_REQUEST: {
                return RPCProtoMessage.decode(in, (MessageLite)Protocol.WriteRequest.getDefaultInstance());
            }
            case RPC_RESPONSE: {
                return RPCProtoMessage.decode(in, (MessageLite)Protocol.Response.getDefaultInstance());
            }
        }
        throw new IllegalArgumentException("Unknown RPCMessage type. type: " + type);
    }

    public static enum Type implements EncodedMessage
    {
        RPC_ERROR_RESPONSE(0),
        RPC_BLOCK_READ_REQUEST(1),
        RPC_BLOCK_READ_RESPONSE(2),
        RPC_BLOCK_WRITE_REQUEST(3),
        RPC_BLOCK_WRITE_RESPONSE(4),
        RPC_FILE_READ_REQUEST(5),
        RPC_FILE_READ_RESPONSE(6),
        RPC_FILE_WRITE_REQUEST(7),
        RPC_FILE_WRITE_RESPONSE(8),
        RPC_READ_REQUEST(100),
        RPC_WRITE_REQUEST(101),
        RPC_RESPONSE(102),
        RPC_UNKNOWN(1000);

        private final int mId;

        private Type(int id) {
            this.mId = id;
        }

        @Override
        public int getEncodedLength() {
            return 4;
        }

        @Override
        public void encode(ByteBuf out) {
            out.writeInt(this.mId);
        }

        public int getId() {
            return this.mId;
        }

        public static Type decode(ByteBuf in) {
            int id = in.readInt();
            switch (id) {
                case 0: {
                    return RPC_ERROR_RESPONSE;
                }
                case 1: {
                    return RPC_BLOCK_READ_REQUEST;
                }
                case 2: {
                    return RPC_BLOCK_READ_RESPONSE;
                }
                case 3: {
                    return RPC_BLOCK_WRITE_REQUEST;
                }
                case 4: {
                    return RPC_BLOCK_WRITE_RESPONSE;
                }
                case 5: {
                    return RPC_FILE_READ_REQUEST;
                }
                case 6: {
                    return RPC_FILE_READ_RESPONSE;
                }
                case 7: {
                    return RPC_FILE_WRITE_REQUEST;
                }
                case 8: {
                    return RPC_FILE_WRITE_RESPONSE;
                }
                case 100: {
                    return RPC_READ_REQUEST;
                }
                case 101: {
                    return RPC_WRITE_REQUEST;
                }
                case 102: {
                    return RPC_RESPONSE;
                }
            }
            throw new IllegalArgumentException("Unknown RPCMessage type id. id: " + id);
        }
    }
}

