/*
 * Decompiled with CFR 0.152.
 */
package alluxio.network.protocol;

import alluxio.network.protocol.RPCMessage;
import alluxio.network.protocol.databuffer.DataBuffer;
import alluxio.network.protocol.databuffer.DataFileChannel;
import alluxio.network.protocol.databuffer.DataNettyBufferV2;
import alluxio.proto.dataserver.Protocol;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class RPCProtoMessage
extends RPCMessage {
    private final MessageLite mMessage;
    private final byte[] mMessageEncoded;
    private final DataBuffer mData;

    public RPCProtoMessage(MessageLite message, DataBuffer data) {
        if (data != null) {
            Preconditions.checkArgument((data instanceof DataNettyBufferV2 || data instanceof DataFileChannel ? 1 : 0) != 0, (Object)"Only DataNettyBufferV2 and DataFileChannel are allowed.");
        }
        this.mMessage = message;
        this.mMessageEncoded = message.toByteArray();
        if (data != null && data.getLength() > 0L) {
            this.mData = data;
        } else if (data != null) {
            data.release();
            this.mData = null;
        } else {
            this.mData = null;
        }
    }

    public RPCProtoMessage(MessageLite message) {
        this(message, null);
    }

    public RPCProtoMessage(byte[] serialized, MessageLite prototype, DataBuffer data) {
        Preconditions.checkArgument((data instanceof DataNettyBufferV2 || data instanceof DataFileChannel ? 1 : 0) != 0, (Object)"Only DataNettyBufferV2 and DataFileChannel are allowed.");
        try {
            this.mMessage = (MessageLite)prototype.getParserForType().parseFrom(serialized);
        }
        catch (InvalidProtocolBufferException e) {
            throw Throwables.propagate((Throwable)e);
        }
        this.mMessageEncoded = Arrays.copyOf(serialized, serialized.length);
        if (data != null && data.getLength() > 0L) {
            this.mData = data;
        } else if (data != null) {
            data.release();
            this.mData = null;
        } else {
            this.mData = null;
        }
    }

    @Override
    public int getEncodedLength() {
        return 4 + this.mMessageEncoded.length;
    }

    @Override
    public void encode(ByteBuf out) {
        out.writeInt(this.mMessageEncoded.length);
        out.writeBytes(this.mMessageEncoded);
    }

    public static RPCProtoMessage decode(ByteBuf in, MessageLite prototype) {
        int length = in.readInt();
        byte[] serialized = new byte[length];
        in.readBytes(serialized);
        in.retain();
        return new RPCProtoMessage(serialized, prototype, new DataNettyBufferV2(in));
    }

    @Override
    public RPCMessage.Type getType() {
        if (this.mMessage instanceof Protocol.ReadRequest) {
            return RPCMessage.Type.RPC_READ_REQUEST;
        }
        if (this.mMessage instanceof Protocol.WriteRequest) {
            return RPCMessage.Type.RPC_WRITE_REQUEST;
        }
        if (this.mMessage instanceof Protocol.Response) {
            return RPCMessage.Type.RPC_RESPONSE;
        }
        return RPCMessage.Type.RPC_UNKNOWN;
    }

    @Override
    public void validate() {
    }

    @Override
    public boolean hasPayload() {
        return this.getPayloadDataBuffer() != null;
    }

    @Override
    public DataBuffer getPayloadDataBuffer() {
        return this.mData;
    }

    public MessageLite getMessage() {
        return this.mMessage;
    }

    public static RPCProtoMessage createResponse(Protocol.Status.Code code, String message, Throwable e, DataBuffer data) {
        Protocol.Status status = Protocol.Status.newBuilder().setCode(code).setMessage(message).build();
        if (e != null) {
            Protocol.Exception.Builder builder = Protocol.Exception.newBuilder();
            String className = e.getClass().getCanonicalName();
            if (className != null) {
                builder.setClassName(className);
            }
            if (e.getMessage() != null) {
                builder.setMessage(e.getMessage());
            }
            status = status.toBuilder().setCause(builder.build()).build();
        }
        Protocol.Response response = Protocol.Response.newBuilder().setStatus(status).build();
        return new RPCProtoMessage((MessageLite)response, data);
    }

    public static RPCProtoMessage createOkResponse(DataBuffer data) {
        return RPCProtoMessage.createResponse(Protocol.Status.Code.OK, "", null, data);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("message", (Object)this.mMessage).add("dataLength", this.mData == null ? 0L : this.mData.getLength()).toString();
    }
}

