/*
 * Decompiled with CFR 0.152.
 */
package alluxio.network.protocol;

import alluxio.network.protocol.RPCMessage;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class RPCResponse
extends RPCMessage {
    public abstract Status getStatus();

    public static enum Status {
        SUCCESS(0),
        UNEXPECTED_STATUS_CODE(1),
        DECODE_ERROR(2),
        UNKNOWN_MESSAGE_ERROR(3),
        FILE_DNE(100),
        BLOCK_LOCK_ERROR(101),
        WRITE_ERROR(102),
        UFS_READ_FAILED(103),
        UFS_WRITE_FAILED(104);

        private static final String DEFAULT_ERROR_STRING = "Unknown error.";
        private static final Map<Short, Status> SHORT_TO_STATUS_MAP;
        private static final Map<Status, String> STATUS_TO_MESSAGE_MAP;
        private final short mId;

        private Status(int id) {
            this.mId = (short)id;
        }

        public short getId() {
            return this.mId;
        }

        public String getMessage() {
            String message = STATUS_TO_MESSAGE_MAP.get((Object)this);
            if (message == null) {
                return DEFAULT_ERROR_STRING;
            }
            return message;
        }

        public static Status fromShort(short id) {
            Status status = SHORT_TO_STATUS_MAP.get(id);
            if (status == null) {
                return UNEXPECTED_STATUS_CODE;
            }
            return status;
        }

        private static String statusToMessage(Status status) {
            switch (status) {
                case SUCCESS: {
                    return "Success!";
                }
                case UNEXPECTED_STATUS_CODE: {
                    return "There was an unexpected status code.";
                }
                case DECODE_ERROR: {
                    return "Decode error. Possible Client/DataServer version incompatibility.";
                }
                case UNKNOWN_MESSAGE_ERROR: {
                    return "Unknown message error. Possible Client/DataServer version incompatibility.";
                }
                case FILE_DNE: {
                    return "File does not exist.";
                }
                case BLOCK_LOCK_ERROR: {
                    return "Failed to lock block.";
                }
                case WRITE_ERROR: {
                    return "Failed to write block.";
                }
            }
            return DEFAULT_ERROR_STRING;
        }

        static {
            SHORT_TO_STATUS_MAP = new HashMap<Short, Status>();
            STATUS_TO_MESSAGE_MAP = new HashMap<Status, String>();
            for (Status status : Status.values()) {
                SHORT_TO_STATUS_MAP.put(status.getId(), status);
                STATUS_TO_MESSAGE_MAP.put(status, Status.statusToMessage(status));
            }
        }
    }
}

