/*
 * Decompiled with CFR 0.152.
 */
package alluxio.network.protocol.databuffer;

import alluxio.network.protocol.databuffer.DataBuffer;
import com.google.common.base.Preconditions;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;

public final class DataByteArrayChannel
implements DataBuffer {
    private final byte[] mByteArray;
    private final long mOffset;
    private final long mLength;

    public DataByteArrayChannel(byte[] byteArray, long offset, long length) {
        this.mByteArray = (byte[])Preconditions.checkNotNull((Object)byteArray);
        this.mOffset = offset;
        this.mLength = length;
    }

    @Override
    public Object getNettyOutput() {
        return Unpooled.wrappedBuffer((byte[])this.mByteArray, (int)((int)this.mOffset), (int)((int)this.mLength));
    }

    @Override
    public long getLength() {
        return this.mLength;
    }

    @Override
    public ByteBuffer getReadOnlyByteBuffer() {
        return ByteBuffer.wrap(this.mByteArray, (int)this.mOffset, (int)this.mLength).asReadOnlyBuffer();
    }

    @Override
    public void readBytes(byte[] dst, int dstIndex, int length) {
        throw new UnsupportedOperationException("DataByteArrayChannel#readBytes is not implemented.");
    }

    @Override
    public int readableBytes() {
        throw new UnsupportedOperationException("DataByteArrayChannel#readableBytes is not implemented.");
    }

    @Override
    public void release() {
    }
}

