/*
 * Decompiled with CFR 0.152.
 */
package alluxio.network.protocol.databuffer;

import alluxio.network.protocol.databuffer.DataBuffer;
import com.google.common.base.Preconditions;
import io.netty.channel.DefaultFileRegion;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public final class DataFileChannel
implements DataBuffer {
    private final FileChannel mFileChannel;
    private final long mOffset;
    private final long mLength;

    public DataFileChannel(FileChannel fileChannel, long offset, long length) {
        this.mFileChannel = (FileChannel)Preconditions.checkNotNull((Object)fileChannel);
        this.mOffset = offset;
        this.mLength = length;
    }

    @Override
    public Object getNettyOutput() {
        return new DefaultFileRegion(this.mFileChannel, this.mOffset, this.mLength);
    }

    @Override
    public long getLength() {
        return this.mLength;
    }

    @Override
    public ByteBuffer getReadOnlyByteBuffer() {
        ByteBuffer buffer = ByteBuffer.allocate((int)this.mLength);
        try {
            int bytesRead;
            this.mFileChannel.position(this.mOffset);
            for (long bytesRemaining = this.mLength; bytesRemaining > 0L && (bytesRead = this.mFileChannel.read(buffer)) >= 0; bytesRemaining -= (long)bytesRead) {
            }
        }
        catch (IOException e) {
            return null;
        }
        ByteBuffer readOnly = buffer.asReadOnlyBuffer();
        readOnly.position(0);
        return readOnly;
    }

    @Override
    public void readBytes(byte[] dst, int dstIndex, int length) {
        throw new UnsupportedOperationException("DataFileChannel#readBytes is not implemented.");
    }

    @Override
    public int readableBytes() {
        throw new UnsupportedOperationException("DataFileChannel#readableBytes is not implemented.");
    }

    @Override
    public void release() {
    }
}

