/*
 * Decompiled with CFR 0.152.
 */
package alluxio.network.protocol.databuffer;

import alluxio.network.protocol.databuffer.DataBuffer;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;

public final class DataNettyBufferV2
implements DataBuffer {
    private final ByteBuf mNettyBuf;

    public DataNettyBufferV2(ByteBuf bytebuf) {
        Preconditions.checkNotNull((Object)bytebuf);
        this.mNettyBuf = bytebuf;
    }

    @Override
    public Object getNettyOutput() {
        return this.mNettyBuf;
    }

    @Override
    public long getLength() {
        return this.mNettyBuf.readableBytes();
    }

    @Override
    public ByteBuffer getReadOnlyByteBuffer() {
        throw new RuntimeException("DataNettyBufferV2::getReadOnlyByteBuffer is not supported.");
    }

    @Override
    public void readBytes(byte[] dst, int dstIndex, int length) {
        this.mNettyBuf.readBytes(dst, dstIndex, length);
    }

    @Override
    public int readableBytes() {
        return this.mNettyBuf.readableBytes();
    }

    @Override
    public void release() {
        this.mNettyBuf.release();
    }
}

