/*
 * Decompiled with CFR 0.152.
 */
package alluxio.replay;

import alluxio.exception.AlluxioException;
import alluxio.thrift.AlluxioTException;
import alluxio.thrift.ThriftIOException;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class ReplayCache<V> {
    private static final long DEFAULT_MAX_SIZE = 10000L;
    private static final long DEFAULT_EXPIRE_MS = 30000L;
    private final Cache<String, V> mCache;

    public static <V> ReplayCache<V> newInstance() {
        return ReplayCache.newInstance(10000L, 30000L);
    }

    public static <V> ReplayCache<V> newInstance(long maxSize, long expireMs) {
        return new ReplayCache<V>(maxSize, expireMs);
    }

    private ReplayCache(long maxSize, long expireMs) {
        this.mCache = CacheBuilder.newBuilder().maximumSize(maxSize).expireAfterWrite(expireMs, TimeUnit.MILLISECONDS).build();
    }

    public V run(String key, final ReplayCallable<V> replayCallable) throws AlluxioTException {
        try {
            return (V)this.mCache.get((Object)key, new Callable<V>(){

                @Override
                public V call() throws Exception {
                    try {
                        return replayCallable.call();
                    }
                    catch (AlluxioException e) {
                        throw e.toThrift();
                    }
                }
            });
        }
        catch (ExecutionException e) {
            Throwables.propagateIfInstanceOf((Throwable)e.getCause(), AlluxioTException.class);
            throw Throwables.propagate((Throwable)e.getCause());
        }
        catch (UncheckedExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }

    public V run(String key, final ReplayCallableThrowsIOException<V> replayCallable) throws AlluxioTException, ThriftIOException {
        try {
            return (V)this.mCache.get((Object)key, new Callable<V>(){

                @Override
                public V call() throws Exception {
                    try {
                        return replayCallable.call();
                    }
                    catch (AlluxioException e) {
                        throw e.toThrift();
                    }
                    catch (IOException e) {
                        throw new ThriftIOException(e.getMessage());
                    }
                }
            });
        }
        catch (ExecutionException e) {
            Throwables.propagateIfInstanceOf((Throwable)e.getCause(), AlluxioTException.class);
            Throwables.propagateIfInstanceOf((Throwable)e.getCause(), ThriftIOException.class);
            throw Throwables.propagate((Throwable)e.getCause());
        }
        catch (UncheckedExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }

    public static interface ReplayCallableThrowsIOException<V> {
        public V call() throws AlluxioException, IOException;
    }

    public static interface ReplayCallable<V> {
        public V call() throws AlluxioException;
    }
}

