/*
 * Decompiled with CFR 0.152.
 */
package alluxio.resource;

import alluxio.clock.Clock;
import alluxio.clock.SystemClock;
import alluxio.resource.Pool;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import io.netty.util.internal.chmv8.ConcurrentHashMapV8;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class DynamicResourcePool<T>
implements Pool<T> {
    protected static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private final ReentrantLock mLock = new ReentrantLock();
    private final Condition mNotEmpty = this.mLock.newCondition();
    private final int mMaxCapacity;
    private final int mMinCapacity;
    @GuardedBy(value="mLock")
    private final Deque<ResourceInternal<T>> mAvailableResources;
    private final ConcurrentHashMapV8<T, ResourceInternal<T>> mResources = new ConcurrentHashMapV8(32);
    private ScheduledExecutorService mExecutor;
    private ScheduledFuture<?> mGcFuture;
    protected Clock mClock = new SystemClock();

    public DynamicResourcePool(Options options) {
        this.mExecutor = (ScheduledExecutorService)Preconditions.checkNotNull((Object)options.getGcExecutor(), (Object)"executor");
        this.mMaxCapacity = options.getMaxCapacity();
        this.mMinCapacity = options.getMinCapacity();
        this.mAvailableResources = new ArrayDeque<ResourceInternal<T>>(Math.min(this.mMaxCapacity, 32));
        this.mGcFuture = this.mExecutor.scheduleAtFixedRate(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList<Object> resourcesToGc = new ArrayList<Object>();
                try {
                    DynamicResourcePool.this.mLock.lock();
                    if (DynamicResourcePool.this.mResources.size() <= DynamicResourcePool.this.mMinCapacity) {
                        return;
                    }
                    int currentSize = DynamicResourcePool.this.mResources.size();
                    Iterator iterator = DynamicResourcePool.this.mAvailableResources.iterator();
                    while (iterator.hasNext()) {
                        ResourceInternal next = (ResourceInternal)iterator.next();
                        if (!DynamicResourcePool.this.shouldGc(next)) continue;
                        resourcesToGc.add(next.mResource);
                        iterator.remove();
                        DynamicResourcePool.this.mResources.remove(next.mResource);
                        if (--currentSize > DynamicResourcePool.this.mMinCapacity) continue;
                        break;
                    }
                }
                finally {
                    DynamicResourcePool.this.mLock.unlock();
                }
                for (Object e : resourcesToGc) {
                    LOG.info("Resource {} is garbage collected.", e);
                    DynamicResourcePool.this.closeResource(e);
                }
            }
        }, options.getInitialDelayMs(), options.getGcIntervalMs(), TimeUnit.MILLISECONDS);
    }

    @Override
    public T acquire() throws IOException, InterruptedException {
        try {
            return this.acquire(100L, TimeUnit.DAYS);
        }
        catch (TimeoutException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T acquire(long time, TimeUnit unit) throws IOException, TimeoutException, InterruptedException {
        ResourceInternal<T> resource;
        long endTimeMs;
        block7: {
            endTimeMs = this.mClock.millis() + unit.toMillis(time);
            resource = this.poll();
            if (resource != null) {
                return (T)this.checkHealthyAndRetry(((ResourceInternal)resource).mResource, endTimeMs);
            }
            if (!this.isFull()) {
                T newResource = this.createNewResource();
                ResourceInternal<T> resourceInternal = new ResourceInternal<T>(newResource);
                if (this.add(resourceInternal)) {
                    return newResource;
                }
                this.closeResource(newResource);
            }
            try {
                long currTimeMs;
                this.mLock.lock();
                do {
                    if ((resource = this.poll()) == null) continue;
                    break block7;
                } while ((currTimeMs = this.mClock.millis()) < endTimeMs && this.mNotEmpty.await(endTimeMs - currTimeMs, TimeUnit.MILLISECONDS));
                throw new TimeoutException("Acquire resource times out.");
            }
            finally {
                this.mLock.unlock();
            }
        }
        return (T)this.checkHealthyAndRetry(((ResourceInternal)resource).mResource, endTimeMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(T resource) {
        if (!this.mResources.containsKey(resource)) {
            throw new IllegalArgumentException("Resource " + resource.toString() + " was not acquired from this resource pool.");
        }
        ResourceInternal resourceInternal = (ResourceInternal)this.mResources.get(resource);
        resourceInternal.setLastAccessTimeMs(this.mClock.millis());
        try {
            this.mLock.lock();
            this.mAvailableResources.addFirst(resourceInternal);
            this.mNotEmpty.signal();
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this.mLock.lock();
            if (this.mAvailableResources.size() != this.mResources.size()) {
                LOG.warn("{} resources are not released when closing the resource pool.", (Object)(this.mResources.size() - this.mAvailableResources.size()));
            }
            for (ResourceInternal<T> resourceInternal : this.mAvailableResources) {
                this.closeResourceSync(((ResourceInternal)resourceInternal).mResource);
            }
            this.mAvailableResources.clear();
        }
        finally {
            this.mLock.unlock();
        }
        this.mGcFuture.cancel(true);
    }

    @Override
    public int size() {
        return this.mResources.size();
    }

    private boolean isFull() {
        return this.mResources.size() >= this.mMaxCapacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean add(ResourceInternal<T> resource) {
        try {
            this.mLock.lock();
            if (this.mResources.size() >= this.mMaxCapacity) {
                boolean bl = false;
                return bl;
            }
            this.mResources.put(((ResourceInternal)resource).mResource, resource);
            boolean bl = true;
            return bl;
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(T resource) {
        try {
            this.mLock.lock();
            this.mResources.remove(resource);
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceInternal<T> poll() {
        try {
            this.mLock.lock();
            ResourceInternal<T> resourceInternal = this.mAvailableResources.pollFirst();
            return resourceInternal;
        }
        finally {
            this.mLock.unlock();
        }
    }

    private T checkHealthyAndRetry(T resource, long endTimeMs) throws IOException, TimeoutException, InterruptedException {
        if (this.isHealthy(resource)) {
            return resource;
        }
        LOG.info("Clearing unhealthy resource {}.", resource);
        this.remove(resource);
        this.closeResource(resource);
        return this.acquire(endTimeMs - this.mClock.millis(), TimeUnit.MILLISECONDS);
    }

    protected abstract boolean shouldGc(ResourceInternal<T> var1);

    protected abstract boolean isHealthy(T var1);

    protected abstract void closeResource(T var1);

    protected abstract void closeResourceSync(T var1);

    protected abstract T createNewResource() throws IOException;

    public static final class Options {
        private int mMaxCapacity = 1024;
        private int mMinCapacity = 1;
        private long mInitialDelayMs = 100L;
        private long mGcIntervalMs = 120000L;
        private ScheduledExecutorService mGcExecutor;

        public int getMaxCapacity() {
            return this.mMaxCapacity;
        }

        public int getMinCapacity() {
            return this.mMinCapacity;
        }

        public long getInitialDelayMs() {
            return this.mInitialDelayMs;
        }

        public long getGcIntervalMs() {
            return this.mGcIntervalMs;
        }

        public ScheduledExecutorService getGcExecutor() {
            return this.mGcExecutor;
        }

        public Options setMaxCapacity(int maxCapacity) {
            Preconditions.checkArgument((maxCapacity >= 1 ? 1 : 0) != 0);
            this.mMaxCapacity = maxCapacity;
            return this;
        }

        public Options setMinCapacity(int minCapacity) {
            Preconditions.checkArgument((minCapacity >= 0 ? 1 : 0) != 0);
            this.mMinCapacity = minCapacity;
            return this;
        }

        public Options setInitialDelayMs(long initialDelayMs) {
            Preconditions.checkArgument((initialDelayMs >= 0L ? 1 : 0) != 0);
            this.mInitialDelayMs = initialDelayMs;
            return this;
        }

        public Options setGcIntervalMs(long gcIntervalMs) {
            Preconditions.checkArgument((gcIntervalMs > 0L ? 1 : 0) != 0);
            this.mGcIntervalMs = gcIntervalMs;
            return this;
        }

        public Options setGcExecutor(ScheduledExecutorService gcExecutor) {
            this.mGcExecutor = gcExecutor;
            return this;
        }

        private Options() {
        }

        public static Options defaultOptions() {
            return new Options();
        }
    }

    protected class ResourceInternal<T> {
        private T mResource;
        private long mLastAccessTimeMs;

        public void setLastAccessTimeMs(long lastAccessTimeMs) {
            this.mLastAccessTimeMs = lastAccessTimeMs;
        }

        public long getLastAccessTimeMs() {
            return this.mLastAccessTimeMs;
        }

        public ResourceInternal(T resource) {
            this.mResource = resource;
            this.mLastAccessTimeMs = DynamicResourcePool.this.mClock.millis();
        }
    }
}

