/*
 * Decompiled with CFR 0.152.
 */
package alluxio.resource;

import alluxio.resource.LockResource;
import com.google.common.base.Preconditions;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class ResourcePool<T> {
    private final ReentrantLock mTakeLock = new ReentrantLock();
    private final Condition mNotEmpty = this.mTakeLock.newCondition();
    protected final int mMaxCapacity;
    protected final ConcurrentLinkedQueue<T> mResources;
    protected final AtomicInteger mCurrentCapacity;

    public ResourcePool(int maxCapacity) {
        this(maxCapacity, new ConcurrentLinkedQueue());
    }

    protected ResourcePool(int maxCapacity, ConcurrentLinkedQueue<T> resources) {
        this.mMaxCapacity = maxCapacity;
        this.mCurrentCapacity = new AtomicInteger();
        this.mResources = resources;
    }

    public T acquire() {
        return this.acquire(null, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T acquire(Integer time, TimeUnit unit) {
        T resource;
        Preconditions.checkState((time == null == (unit == null) ? 1 : 0) != 0);
        long endTimeMs = 0L;
        if (time != null) {
            endTimeMs = System.currentTimeMillis() + unit.toMillis(time.intValue());
        }
        if ((resource = this.mResources.poll()) != null) {
            return resource;
        }
        if (this.mCurrentCapacity.getAndIncrement() < this.mMaxCapacity) {
            return this.createNewResource();
        }
        this.mCurrentCapacity.decrementAndGet();
        try {
            this.mTakeLock.lockInterruptibly();
            try {
                while (true) {
                    if ((resource = this.mResources.poll()) != null) {
                        T t = resource;
                        return t;
                    }
                    if (time != null) {
                        long currTimeMs = System.currentTimeMillis();
                        if (currTimeMs >= endTimeMs) {
                            T t = null;
                            return t;
                        }
                        if (this.mNotEmpty.await(endTimeMs - currTimeMs, TimeUnit.MILLISECONDS)) continue;
                        T t = null;
                        return t;
                    }
                    this.mNotEmpty.await();
                }
            }
            finally {
                this.mTakeLock.unlock();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract void close();

    public void release(T resource) {
        this.mResources.add(resource);
        try (LockResource r = new LockResource(this.mTakeLock);){
            this.mNotEmpty.signal();
        }
    }

    protected abstract T createNewResource();
}

