/*
 * Decompiled with CFR 0.152.
 */
package alluxio.retry;

import alluxio.retry.RetryPolicy;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CountingRetry
implements RetryPolicy {
    private final int mMaxRetries;
    private int mCount = 0;

    public CountingRetry(int maxRetries) {
        Preconditions.checkArgument((maxRetries > 0 ? 1 : 0) != 0, (Object)"Max retries must be a positive number");
        this.mMaxRetries = maxRetries;
    }

    @Override
    public int getRetryCount() {
        return this.mCount;
    }

    @Override
    public boolean attemptRetry() {
        if (this.mMaxRetries > this.mCount) {
            ++this.mCount;
            return true;
        }
        return false;
    }
}

