/*
 * Decompiled with CFR 0.152.
 */
package alluxio.retry;

import alluxio.retry.SleepingRetry;
import com.google.common.base.Preconditions;
import java.util.Random;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ExponentialBackoffRetry
extends SleepingRetry {
    private final Random mRandom = new Random();
    private final int mBaseSleepTimeMs;
    private final int mMaxSleepMs;

    public ExponentialBackoffRetry(int baseSleepTimeMs, int maxSleepMs, int maxRetries) {
        super(maxRetries);
        Preconditions.checkArgument((baseSleepTimeMs >= 0 ? 1 : 0) != 0, (Object)"Base must be a positive number, or 0");
        Preconditions.checkArgument((maxSleepMs >= 0 ? 1 : 0) != 0, (Object)"Max must be a positive number, or 0");
        this.mBaseSleepTimeMs = baseSleepTimeMs;
        this.mMaxSleepMs = maxSleepMs;
    }

    @Override
    protected long getSleepTime() {
        int count = this.getRetryCount();
        if (count >= 30) {
            return this.mMaxSleepMs;
        }
        int sleepMs = this.mBaseSleepTimeMs * Math.max(1, this.mRandom.nextInt(1 << count + 1));
        return Math.min(ExponentialBackoffRetry.abs(sleepMs, this.mMaxSleepMs), this.mMaxSleepMs);
    }

    private static int abs(int value, int defaultValue) {
        int result = Math.abs(value);
        if (result == Integer.MIN_VALUE) {
            result = defaultValue;
        }
        return result;
    }
}

