/*
 * Decompiled with CFR 0.152.
 */
package alluxio.retry;

import alluxio.retry.RetryPolicy;
import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class SleepingRetry
implements RetryPolicy {
    private final int mMaxRetries;
    private int mCount = 0;

    protected SleepingRetry(int maxRetries) {
        Preconditions.checkArgument((maxRetries > 0 ? 1 : 0) != 0, (Object)"Max retries must be a positive number");
        this.mMaxRetries = maxRetries;
    }

    @Override
    public int getRetryCount() {
        return this.mCount;
    }

    @Override
    public boolean attemptRetry() {
        if (this.mMaxRetries > this.mCount) {
            try {
                this.getSleepUnit().sleep(this.getSleepTime());
                ++this.mCount;
                return true;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
        return false;
    }

    protected TimeUnit getSleepUnit() {
        return TimeUnit.MILLISECONDS;
    }

    protected abstract long getSleepTime();
}

