/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security;

import alluxio.Configuration;
import alluxio.PropertyKey;
import alluxio.security.User;
import alluxio.security.authentication.AuthType;
import alluxio.security.login.AppLoginModule;
import alluxio.security.login.LoginModuleConfiguration;
import java.io.IOException;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

@ThreadSafe
public final class LoginUser {
    private static User sLoginUser;

    private LoginUser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static User get() throws IOException {
        if (sLoginUser != null) return sLoginUser;
        Class<LoginUser> clazz = LoginUser.class;
        synchronized (LoginUser.class) {
            if (sLoginUser != null) return sLoginUser;
            sLoginUser = LoginUser.login();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sLoginUser;
        }
    }

    private static User login() throws IOException {
        String msg;
        AuthType authType = Configuration.getEnum(PropertyKey.SECURITY_AUTHENTICATION_TYPE, AuthType.class);
        LoginUser.checkSecurityEnabled(authType);
        Subject subject = new Subject();
        try {
            AppLoginModule.AppCallbackHandler callbackHandler = null;
            if (authType.equals((Object)AuthType.SIMPLE) || authType.equals((Object)AuthType.CUSTOM)) {
                callbackHandler = new AppLoginModule.AppCallbackHandler();
            }
            LoginContext loginContext = new LoginContext(authType.getAuthName(), subject, callbackHandler, new LoginModuleConfiguration());
            loginContext.login();
        }
        catch (LoginException e) {
            throw new IOException("Failed to login: " + e.getMessage(), e);
        }
        Set<User> userSet = subject.getPrincipals(User.class);
        if (userSet.isEmpty()) {
            msg = String.format("Failed to login: No Alluxio User is found. Current login principals are %s.%n If you are running hadoop with Alluxio, please double check whether you have alluxio client jar included in HADOOP_CLASSPATH. Otherwise, you are expected to see this error.", subject.getPrincipals().toString());
            throw new IOException(msg);
        }
        if (userSet.size() > 1) {
            msg = String.format("Failed to login: More than one Alluxio User is found. Current login principals are %s.", subject.getPrincipals().toString());
            throw new IOException(msg);
        }
        return userSet.iterator().next();
    }

    private static void checkSecurityEnabled(AuthType authType) {
        if (authType != AuthType.SIMPLE && authType != AuthType.CUSTOM) {
            throw new UnsupportedOperationException("User is not supported in " + authType.getAuthName() + " mode");
        }
    }
}

