/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authentication;

import alluxio.exception.AccessControlException;
import alluxio.exception.ExceptionMessage;
import alluxio.security.User;
import alluxio.util.SecurityUtils;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class AuthenticatedClientUser {
    private static ThreadLocal<User> sUserThreadLocal = new ThreadLocal();

    public static void set(String userName) {
        sUserThreadLocal.set(new User(userName));
    }

    public static User get() throws IOException {
        if (!SecurityUtils.isAuthenticationEnabled()) {
            throw new IOException(ExceptionMessage.AUTHENTICATION_IS_NOT_ENABLED.getMessage(new Object[0]));
        }
        return sUserThreadLocal.get();
    }

    public static String getClientUser() throws AccessControlException {
        try {
            User user = AuthenticatedClientUser.get();
            if (user == null) {
                throw new AccessControlException(ExceptionMessage.AUTHORIZED_CLIENT_USER_IS_NULL.getMessage(new Object[0]));
            }
            return user.getName();
        }
        catch (IOException e) {
            throw new AccessControlException(ExceptionMessage.AUTHENTICATION_IS_NOT_ENABLED.getMessage(new Object[0]));
        }
    }

    public static synchronized void remove() {
        sUserThreadLocal.remove();
    }
}

