/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authentication;

import alluxio.Configuration;
import alluxio.PropertyKey;
import alluxio.security.authentication.AuthType;
import alluxio.security.authentication.CustomAuthenticationProvider;
import alluxio.security.authentication.SimpleAuthenticationProvider;
import javax.security.sasl.AuthenticationException;

public interface AuthenticationProvider {
    public void authenticate(String var1, String var2) throws AuthenticationException;

    public static class Factory {
        private Factory() {
        }

        public static AuthenticationProvider create(AuthType authType) throws AuthenticationException {
            switch (authType) {
                case SIMPLE: {
                    return new SimpleAuthenticationProvider();
                }
                case CUSTOM: {
                    String customProviderName = Configuration.get(PropertyKey.SECURITY_AUTHENTICATION_CUSTOM_PROVIDER_CLASS);
                    return new CustomAuthenticationProvider(customProviderName);
                }
            }
            throw new AuthenticationException("Unsupported AuthType: " + authType.getAuthName());
        }
    }
}

