/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authentication;

import alluxio.security.authentication.AuthenticationProvider;
import alluxio.util.CommonUtils;
import javax.annotation.concurrent.NotThreadSafe;
import javax.security.sasl.AuthenticationException;

@NotThreadSafe
public final class CustomAuthenticationProvider
implements AuthenticationProvider {
    private final AuthenticationProvider mCustomProvider;

    public CustomAuthenticationProvider(String providerName) {
        Class<?> customProviderClass;
        try {
            customProviderClass = Class.forName(providerName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(providerName + " not found");
        }
        try {
            this.mCustomProvider = (AuthenticationProvider)CommonUtils.createNewClassInstance(customProviderClass, null, null);
        }
        catch (Exception e) {
            throw new RuntimeException(customProviderClass.getName() + " instantiate failed :" + e.getMessage());
        }
    }

    public AuthenticationProvider getCustomProvider() {
        return this.mCustomProvider;
    }

    @Override
    public void authenticate(String user, String password) throws AuthenticationException {
        this.mCustomProvider.authenticate(user, password);
    }
}

