/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authentication;

import alluxio.Configuration;
import alluxio.PropertyKey;
import alluxio.security.authentication.TransportProvider;
import alluxio.security.authentication.TransportProviderUtils;
import java.net.InetSocketAddress;
import javax.annotation.concurrent.ThreadSafe;
import javax.security.auth.Subject;
import javax.security.sasl.SaslException;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportFactory;

@ThreadSafe
public final class NoSaslTransportProvider
implements TransportProvider {
    private final int mSocketTimeoutMs = Configuration.getInt(PropertyKey.SECURITY_AUTHENTICATION_SOCKET_TIMEOUT_MS);
    private final int mThriftFrameSizeMax = (int)Configuration.getBytes(PropertyKey.NETWORK_THRIFT_FRAME_SIZE_BYTES_MAX);

    @Override
    public TTransport getClientTransport(InetSocketAddress serverAddress) {
        TSocket tTransport = TransportProviderUtils.createThriftSocket(serverAddress, this.mSocketTimeoutMs);
        return new TFramedTransport((TTransport)tTransport, this.mThriftFrameSizeMax);
    }

    @Override
    public TTransport getClientTransport(Subject subject, InetSocketAddress serverAddress) {
        TSocket tTransport = TransportProviderUtils.createThriftSocket(serverAddress, this.mSocketTimeoutMs);
        return new TFramedTransport((TTransport)tTransport, this.mThriftFrameSizeMax);
    }

    @Override
    public TTransportFactory getServerTransportFactory() throws SaslException {
        return new TFramedTransport.Factory(this.mThriftFrameSizeMax);
    }

    @Override
    public TTransportFactory getServerTransportFactory(Runnable runnable) throws SaslException {
        return new TFramedTransport.Factory(this.mThriftFrameSizeMax);
    }
}

