/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authentication;

import alluxio.security.authentication.AuthenticatedClientUser;
import alluxio.security.authentication.AuthenticationProvider;
import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;

public final class PlainSaslServerCallbackHandler
implements CallbackHandler {
    private final AuthenticationProvider mAuthenticationProvider;
    private final Runnable mCallback;

    public PlainSaslServerCallbackHandler(AuthenticationProvider authenticationProvider, Runnable callback) {
        this.mAuthenticationProvider = (AuthenticationProvider)Preconditions.checkNotNull((Object)authenticationProvider);
        this.mCallback = callback;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        String username = null;
        String password = null;
        AuthorizeCallback ac = null;
        for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                NameCallback nc = (NameCallback)callback;
                username = nc.getName();
                continue;
            }
            if (callback instanceof PasswordCallback) {
                PasswordCallback pc = (PasswordCallback)callback;
                password = new String(pc.getPassword());
                continue;
            }
            if (callback instanceof AuthorizeCallback) {
                ac = (AuthorizeCallback)callback;
                continue;
            }
            throw new UnsupportedCallbackException(callback, "Unsupport callback");
        }
        this.mAuthenticationProvider.authenticate(username, password);
        if (ac != null) {
            ac.setAuthorized(true);
            AuthenticatedClientUser.set(ac.getAuthorizedID());
            this.mCallback.run();
        }
    }
}

