/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authentication;

import alluxio.Configuration;
import alluxio.PropertyKey;
import alluxio.security.LoginUser;
import alluxio.security.User;
import alluxio.security.authentication.AuthType;
import alluxio.security.authentication.AuthenticationProvider;
import alluxio.security.authentication.PlainSaslClientCallbackHandler;
import alluxio.security.authentication.PlainSaslServerCallbackHandler;
import alluxio.security.authentication.PlainSaslServerProvider;
import alluxio.security.authentication.TransportProvider;
import alluxio.security.authentication.TransportProviderUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.Security;
import java.util.HashMap;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import org.apache.thrift.transport.TSaslClientTransport;
import org.apache.thrift.transport.TSaslServerTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportFactory;

@ThreadSafe
public final class PlainSaslTransportProvider
implements TransportProvider {
    private int mSocketTimeoutMs = Configuration.getInt(PropertyKey.SECURITY_AUTHENTICATION_SOCKET_TIMEOUT_MS);

    @Override
    public TTransport getClientTransport(InetSocketAddress serverAddress) throws IOException {
        String username = LoginUser.get().getName();
        String password = "noPassword";
        return this.getClientTransport(username, password, serverAddress);
    }

    @Override
    public TTransport getClientTransport(Subject subject, InetSocketAddress serverAddress) throws IOException {
        Set<User> user;
        String username = null;
        String password = "noPassword";
        if (subject != null && (user = subject.getPrincipals(User.class)) != null && !user.isEmpty()) {
            username = user.iterator().next().getName();
        }
        if (username == null || username.isEmpty()) {
            username = LoginUser.get().getName();
        }
        return this.getClientTransport(username, password, serverAddress);
    }

    public TTransport getClientTransport(String username, String password, InetSocketAddress serverAddress) throws SaslException {
        TSocket wrappedTransport = TransportProviderUtils.createThriftSocket(serverAddress, this.mSocketTimeoutMs);
        return new TSaslClientTransport("PLAIN", null, null, null, new HashMap(), (CallbackHandler)new PlainSaslClientCallbackHandler(username, password), (TTransport)wrappedTransport);
    }

    @Override
    public TTransportFactory getServerTransportFactory() throws SaslException {
        return this.getServerTransportFactory(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    @Override
    public TTransportFactory getServerTransportFactory(Runnable runnable) throws SaslException {
        AuthType authType = Configuration.getEnum(PropertyKey.SECURITY_AUTHENTICATION_TYPE, AuthType.class);
        TSaslServerTransport.Factory saslFactory = new TSaslServerTransport.Factory();
        AuthenticationProvider provider = AuthenticationProvider.Factory.create(authType);
        saslFactory.addServerDefinition("PLAIN", null, null, new HashMap(), (CallbackHandler)new PlainSaslServerCallbackHandler(provider, runnable));
        return saslFactory;
    }

    static {
        Security.addProvider(new PlainSaslServerProvider());
    }
}

