/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authentication;

import alluxio.Configuration;
import alluxio.PropertyKey;
import alluxio.security.authentication.AuthType;
import alluxio.security.authentication.NoSaslTransportProvider;
import alluxio.security.authentication.PlainSaslTransportProvider;
import java.io.IOException;
import java.net.InetSocketAddress;
import javax.security.auth.Subject;
import javax.security.sasl.SaslException;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportFactory;

public interface TransportProvider {
    public TTransport getClientTransport(InetSocketAddress var1) throws IOException;

    public TTransport getClientTransport(Subject var1, InetSocketAddress var2) throws IOException;

    public TTransportFactory getServerTransportFactory() throws SaslException;

    public TTransportFactory getServerTransportFactory(Runnable var1) throws SaslException;

    public static class Factory {
        private Factory() {
        }

        public static TransportProvider create() {
            AuthType authType = Configuration.getEnum(PropertyKey.SECURITY_AUTHENTICATION_TYPE, AuthType.class);
            switch (authType) {
                case NOSASL: {
                    return new NoSaslTransportProvider();
                }
                case SIMPLE: 
                case CUSTOM: {
                    return new PlainSaslTransportProvider();
                }
                case KERBEROS: {
                    throw new UnsupportedOperationException("getClientTransport: Kerberos is not supported currently.");
                }
            }
            throw new UnsupportedOperationException("getClientTransport: Unsupported authentication type: " + authType.getAuthName());
        }
    }
}

