/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authorization;

import alluxio.Configuration;
import alluxio.PropertyKey;
import alluxio.exception.ExceptionMessage;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;

@NotThreadSafe
public final class Mode {
    private Bits mOwnerBits;
    private Bits mGroupBits;
    private Bits mOtherBits;

    public Mode(Bits ownerBits, Bits groupBits, Bits otherBits) {
        this.set(ownerBits, groupBits, otherBits);
    }

    public Mode(short mode) {
        this.fromShort(mode);
    }

    public Mode(Mode mode) {
        this.set(mode.mOwnerBits, mode.mGroupBits, mode.mOtherBits);
    }

    public Bits getOwnerBits() {
        return this.mOwnerBits;
    }

    public static Bits extractOwnerBits(short mode) {
        return Bits.values()[mode >>> 6 & 7];
    }

    public void setOwnerBits(Bits bits) {
        this.mOwnerBits = bits;
    }

    public Bits getGroupBits() {
        return this.mGroupBits;
    }

    public static Bits extractGroupBits(short mode) {
        return Bits.values()[mode >>> 3 & 7];
    }

    public void setGroupBits(Bits bits) {
        this.mGroupBits = bits;
    }

    public Bits getOtherBits() {
        return this.mOtherBits;
    }

    public static Bits extractOtherBits(short mode) {
        return Bits.values()[mode & 7];
    }

    public void setOtherBits(Bits bits) {
        this.mOtherBits = bits;
    }

    private void set(Bits u, Bits g, Bits o) {
        this.mOwnerBits = u;
        this.mGroupBits = g;
        this.mOtherBits = o;
    }

    public void fromShort(short n) {
        Bits[] v = Bits.values();
        this.set(v[n >>> 6 & 7], v[n >>> 3 & 7], v[n & 7]);
    }

    public short toShort() {
        int s = this.mOwnerBits.ordinal() << 6 | this.mGroupBits.ordinal() << 3 | this.mOtherBits.ordinal();
        return (short)s;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Mode) {
            Mode that = (Mode)obj;
            return this.mOwnerBits == that.mOwnerBits && this.mGroupBits == that.mGroupBits && this.mOtherBits == that.mOtherBits;
        }
        return false;
    }

    public int hashCode() {
        return this.toShort();
    }

    public String toString() {
        return this.mOwnerBits.toString() + this.mGroupBits.toString() + this.mOtherBits.toString();
    }

    public Mode applyUMask(Mode umask) {
        return new Mode(this.mOwnerBits.and(umask.mOwnerBits.not()), this.mGroupBits.and(umask.mGroupBits.not()), this.mOtherBits.and(umask.mOtherBits.not()));
    }

    public Mode applyUMask() {
        return this.applyUMask(Mode.getUMask());
    }

    public static Mode getDefault() {
        return new Mode(511);
    }

    public static Mode createNoAccess() {
        return new Mode(Bits.NONE, Bits.NONE, Bits.NONE);
    }

    public static Mode createFullAccess() {
        return new Mode(Bits.ALL, Bits.ALL, Bits.ALL);
    }

    public static Mode getUMask() {
        int umask = 18;
        String confUmask = Configuration.get(PropertyKey.SECURITY_AUTHORIZATION_PERMISSION_UMASK);
        if (confUmask != null) {
            if (confUmask.length() > 4 || !Mode.tryParseInt(confUmask)) {
                throw new IllegalArgumentException(ExceptionMessage.INVALID_CONFIGURATION_VALUE.getMessage(new Object[]{confUmask, PropertyKey.SECURITY_AUTHORIZATION_PERMISSION_UMASK}));
            }
            int newUmask = 0;
            int lastIndex = confUmask.length() - 1;
            for (int i = 0; i <= lastIndex; ++i) {
                newUmask += confUmask.charAt(i) - 48 << 3 * (lastIndex - i);
            }
            umask = newUmask;
        }
        return new Mode((short)umask);
    }

    private static boolean tryParseInt(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @ThreadSafe
    public static enum Bits {
        NONE("---"),
        EXECUTE("--x"),
        WRITE("-w-"),
        WRITE_EXECUTE("-wx"),
        READ("r--"),
        READ_EXECUTE("r-x"),
        READ_WRITE("rw-"),
        ALL("rwx");

        private final String mString;
        private static final Bits[] SVALS;

        private Bits(String s) {
            this.mString = s;
        }

        public static Bits fromShort(short bits) {
            return SVALS[bits];
        }

        public String toString() {
            return this.mString;
        }

        public boolean imply(Bits that) {
            if (that != null) {
                return (this.ordinal() & that.ordinal()) == that.ordinal();
            }
            return false;
        }

        public Bits and(Bits that) {
            Preconditions.checkNotNull((Object)((Object)that));
            return SVALS[this.ordinal() & that.ordinal()];
        }

        public Bits or(Bits that) {
            Preconditions.checkNotNull((Object)((Object)that));
            return SVALS[this.ordinal() | that.ordinal()];
        }

        public Bits not() {
            return SVALS[7 - this.ordinal()];
        }

        static {
            SVALS = Bits.values();
        }
    }
}

