/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authorization;

import alluxio.exception.ExceptionMessage;
import alluxio.exception.PreconditionMessage;
import alluxio.security.LoginUser;
import alluxio.security.User;
import alluxio.security.authentication.AuthenticatedClientUser;
import alluxio.security.authorization.Mode;
import alluxio.util.CommonUtils;
import alluxio.util.SecurityUtils;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class Permission {
    private static final Mode FILE_UMASK = new Mode(73);
    private String mOwner;
    private String mGroup;
    private Mode mMode;

    public Permission(String owner, String group, Mode mode) {
        Preconditions.checkNotNull((Object)owner, (Object)((Object)PreconditionMessage.PERMISSION_OWNER_IS_NULL));
        Preconditions.checkNotNull((Object)group, (Object)((Object)PreconditionMessage.PERMISSION_GROUP_IS_NULL));
        Preconditions.checkNotNull((Object)mode, (Object)((Object)PreconditionMessage.PERMISSION_MODE_IS_NULL));
        this.mOwner = owner;
        this.mGroup = group;
        this.mMode = mode;
    }

    public Permission(String owner, String group, short mode) {
        this(owner, group, new Mode(mode));
    }

    public Permission(Permission p) {
        this(p.getOwner(), p.getGroup(), new Mode(p.getMode()));
    }

    public String getOwner() {
        return this.mOwner;
    }

    public String getGroup() {
        return this.mGroup;
    }

    public Mode getMode() {
        return this.mMode;
    }

    public Permission applyUMask(Mode umask) {
        this.mMode = this.mMode.applyUMask(umask);
        return this;
    }

    public Permission applyFileUMask() {
        this.mMode = this.mMode.applyUMask(Mode.getUMask()).applyUMask(FILE_UMASK);
        return this;
    }

    public Permission applyDirectoryUMask() {
        this.mMode = this.mMode.applyUMask(Mode.getUMask());
        return this;
    }

    public Permission setMode(Mode mode) {
        this.mMode = mode;
        return this;
    }

    public Permission setMode(short mode) {
        this.mMode = new Mode(mode);
        return this;
    }

    public Permission setOwnerFromThriftClient() throws IOException {
        if (!SecurityUtils.isAuthenticationEnabled()) {
            return this;
        }
        User user = AuthenticatedClientUser.get();
        if (user == null) {
            throw new IOException(ExceptionMessage.AUTHORIZED_CLIENT_USER_IS_NULL.getMessage(new Object[0]));
        }
        this.mOwner = user.getName();
        this.mGroup = CommonUtils.getPrimaryGroupName(user.getName());
        return this;
    }

    public Permission setOwnerFromLoginModule() throws IOException {
        String user;
        if (!SecurityUtils.isAuthenticationEnabled()) {
            return this;
        }
        this.mOwner = user = LoginUser.get().getName();
        this.mGroup = CommonUtils.getPrimaryGroupName(user);
        return this;
    }

    public static Permission defaults() {
        return new Permission("", "", Mode.createFullAccess());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Permission)) {
            return false;
        }
        Permission that = (Permission)o;
        return Objects.equal((Object)this.mOwner, (Object)that.mOwner) && Objects.equal((Object)this.mGroup, (Object)that.mGroup) && Objects.equal((Object)this.mMode, (Object)that.mMode);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mOwner, this.mGroup, this.mMode});
    }

    public String toString() {
        return this.mOwner + ":" + this.mGroup + ":" + this.mMode;
    }
}

