/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.group;

import alluxio.Configuration;
import alluxio.PropertyKey;
import alluxio.security.group.GroupMappingService;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class CachedGroupMapping
implements GroupMappingService {
    private final GroupMappingService mService;
    private final boolean mCacheEnabled;
    private LoadingCache<String, List<String>> mCache;
    private static final long MAXSIZE = 10000L;
    private final ThreadFactory mThreadFactory = new ThreadFactoryBuilder().setNameFormat("UserGroupMappingCachePool-%d").setDaemon(true).build();
    private final ExecutorService mParentExecutor = Executors.newSingleThreadExecutor(this.mThreadFactory);
    private final ListeningExecutorService mExecutorService = MoreExecutors.listeningDecorator((ExecutorService)this.mParentExecutor);

    public CachedGroupMapping(GroupMappingService service) {
        this.mService = service;
        long timeoutMs = Long.parseLong(Configuration.get(PropertyKey.SECURITY_GROUP_MAPPING_CACHE_TIMEOUT_MS));
        boolean bl = this.mCacheEnabled = timeoutMs > 0L;
        if (this.mCacheEnabled) {
            this.mCache = CacheBuilder.newBuilder().maximumSize(10000L).refreshAfterWrite(timeoutMs, TimeUnit.MILLISECONDS).expireAfterWrite(10L * timeoutMs, TimeUnit.MILLISECONDS).build((CacheLoader)new GroupMappingCacheLoader());
        }
    }

    @Override
    public List<String> getGroups(String user) throws IOException {
        if (!this.mCacheEnabled) {
            return this.mService.getGroups(user);
        }
        try {
            return (List)this.mCache.get((Object)user);
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
    }

    private class GroupMappingCacheLoader
    extends CacheLoader<String, List<String>> {
        public List<String> load(String user) throws IOException {
            return CachedGroupMapping.this.mService.getGroups(user);
        }

        public ListenableFuture<List<String>> reload(final String user, List<String> oldValue) throws IOException {
            ListenableFuture listenableFuture = CachedGroupMapping.this.mExecutorService.submit((Callable)new Callable<List<String>>(){

                @Override
                public List<String> call() throws IOException {
                    return GroupMappingCacheLoader.this.load(user);
                }
            });
            return listenableFuture;
        }
    }
}

