/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.group;

import alluxio.Configuration;
import alluxio.PropertyKey;
import alluxio.security.group.CachedGroupMapping;
import alluxio.util.CommonUtils;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface GroupMappingService {
    public List<String> getGroups(String var1) throws IOException;

    public static class Factory {
        private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
        private static CachedGroupMapping sCachedGroupMapping = null;

        private Factory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static GroupMappingService get() {
            if (sCachedGroupMapping != null) return sCachedGroupMapping;
            Class<Factory> clazz = Factory.class;
            synchronized (Factory.class) {
                if (sCachedGroupMapping != null) return sCachedGroupMapping;
                try {
                    LOG.debug("Creating new Groups object");
                    GroupMappingService groupMappingService = (GroupMappingService)CommonUtils.createNewClassInstance(Configuration.getClass(PropertyKey.SECURITY_GROUP_MAPPING_CLASS), null, null);
                    sCachedGroupMapping = new CachedGroupMapping(groupMappingService);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return sCachedGroupMapping;
            }
        }
    }
}

