/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.login;

import alluxio.security.User;
import alluxio.security.login.LoginModuleConfigurationUtils;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

@NotThreadSafe
public final class AlluxioLoginModule
implements LoginModule {
    private Subject mSubject;
    private User mUser;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.mSubject = subject;
    }

    @Override
    public boolean login() throws LoginException {
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        this.logout();
        this.mUser = null;
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.mSubject.getPrincipals(User.class).isEmpty()) {
            return true;
        }
        Principal user = null;
        if (user == null) {
            user = this.getPrincipalUser(LoginModuleConfigurationUtils.OS_PRINCIPAL_CLASS_NAME);
        }
        if (user != null) {
            this.mUser = new User(user.getName());
            this.mSubject.getPrincipals().add(this.mUser);
            return true;
        }
        throw new LoginException("Cannot find a user");
    }

    @Override
    public boolean logout() throws LoginException {
        if (this.mSubject.isReadOnly()) {
            throw new LoginException("logout Failed: Subject is Readonly.");
        }
        if (this.mUser != null) {
            this.mSubject.getPrincipals().remove(this.mUser);
        }
        return true;
    }

    private Principal getPrincipalUser(String className) throws LoginException {
        Class<?> clazz;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        try {
            Class<?> tmpClazz;
            clazz = tmpClazz = loader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new LoginException("Unable to find JAAS principal class:" + e.getMessage());
        }
        Set<?> userSet = this.mSubject.getPrincipals(clazz);
        if (!userSet.isEmpty()) {
            if (userSet.size() == 1) {
                return (Principal)userSet.iterator().next();
            }
            throw new LoginException("More than one instance of Principal " + className + " is found");
        }
        return null;
    }
}

