/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs;

import alluxio.AlluxioURI;
import alluxio.collections.Pair;
import alluxio.underfs.UnderFileStatus;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.options.CreateOptions;
import alluxio.underfs.options.DeleteOptions;
import alluxio.underfs.options.ListOptions;
import alluxio.underfs.options.MkdirsOptions;
import alluxio.underfs.options.OpenOptions;
import alluxio.util.io.PathUtils;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class BaseUnderFileSystem
implements UnderFileSystem {
    protected final AlluxioURI mUri;
    protected HashMap<String, String> mProperties = new HashMap();

    protected BaseUnderFileSystem(AlluxioURI uri) {
        this.mUri = (AlluxioURI)Preconditions.checkNotNull((Object)uri);
    }

    @Override
    public void configureProperties() throws IOException {
    }

    @Override
    public OutputStream create(String path) throws IOException {
        return this.create(path, CreateOptions.defaults().setCreateParent(true));
    }

    @Override
    public boolean deleteDirectory(String path) throws IOException {
        return this.deleteDirectory(path, DeleteOptions.defaults());
    }

    @Override
    public boolean exists(String path) throws IOException {
        return this.isFile(path) || this.isDirectory(path);
    }

    @Override
    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.mProperties);
    }

    @Override
    public UnderFileStatus[] listStatus(String path, ListOptions options) throws IOException {
        if (!options.isRecursive()) {
            return this.listStatus(path);
        }
        path = BaseUnderFileSystem.validatePath(path);
        ArrayList<UnderFileStatus> returnPaths = new ArrayList<UnderFileStatus>();
        ArrayDeque<Pair<String, UnderFileStatus>> pathsToProcess = new ArrayDeque<Pair<String, UnderFileStatus>>();
        UnderFileStatus[] subpaths = this.listStatus(path);
        if (subpaths == null) {
            return null;
        }
        for (UnderFileStatus subp : subpaths) {
            pathsToProcess.add(new Pair<String, UnderFileStatus>(PathUtils.concatPath(path, subp.getName()), subp));
        }
        while (!pathsToProcess.isEmpty()) {
            Pair pathToProcessPair = (Pair)pathsToProcess.remove();
            String pathToProcess = (String)pathToProcessPair.getFirst();
            UnderFileStatus pathStatus = (UnderFileStatus)pathToProcessPair.getSecond();
            returnPaths.add(new UnderFileStatus(pathToProcess.substring(path.length() + 1), pathStatus.isDirectory()));
            if (!pathStatus.isDirectory() || (subpaths = this.listStatus(pathToProcess)) == null) continue;
            for (UnderFileStatus subp : subpaths) {
                pathsToProcess.add(new Pair<String, UnderFileStatus>(PathUtils.concatPath(pathToProcess, subp.getName()), subp));
            }
        }
        return returnPaths.toArray(new UnderFileStatus[returnPaths.size()]);
    }

    @Override
    public InputStream open(String path) throws IOException {
        return this.open(path, OpenOptions.defaults());
    }

    @Override
    public boolean mkdirs(String path) throws IOException {
        return this.mkdirs(path, MkdirsOptions.defaults());
    }

    @Override
    public AlluxioURI resolveUri(AlluxioURI ufsBaseUri, String alluxioPath) {
        return new AlluxioURI(ufsBaseUri.getScheme(), ufsBaseUri.getAuthority(), PathUtils.concatPath(ufsBaseUri.getPath(), alluxioPath), ufsBaseUri.getQueryMap());
    }

    @Override
    public void setProperties(Map<String, String> properties) {
        this.mProperties.clear();
        this.mProperties.putAll(properties);
    }

    protected static String validatePath(String path) {
        return new AlluxioURI(path).toString();
    }
}

