/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs;

import alluxio.Configuration;
import alluxio.PropertyKey;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class MultiRangeObjectInputStream
extends InputStream {
    protected boolean mClosed;
    protected InputStream mStream;
    protected long mPos;
    protected long mEndPos;

    @Override
    public void close() throws IOException {
        if (!this.mClosed) {
            this.closeStream();
        }
        this.mClosed = true;
    }

    @Override
    public int read() throws IOException {
        this.openStream();
        int value = this.mStream.read();
        if (value != -1) {
            ++this.mPos;
            this.closeStreamIfBoundary();
        }
        return value;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int offset, int length) throws IOException {
        if (length == 0) {
            return 0;
        }
        this.openStream();
        int read = this.mStream.read(b, offset, length);
        if (read != -1) {
            this.mPos += (long)read;
            this.closeStreamIfBoundary();
        }
        return read;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        this.closeStream();
        this.mPos += n;
        this.openStream();
        return n;
    }

    private void closeStreamIfBoundary() throws IOException {
        if (this.mPos >= this.mEndPos) {
            this.closeStream();
        }
    }

    private void closeStream() throws IOException {
        if (this.mStream == null) {
            return;
        }
        this.mStream.close();
        this.mStream = null;
    }

    protected abstract InputStream createStream(long var1, long var3) throws IOException;

    private long getBlockSize() {
        return Configuration.getBytes(PropertyKey.USER_BLOCK_SIZE_BYTES_DEFAULT);
    }

    private void openStream() throws IOException {
        long endPos;
        if (this.mClosed) {
            throw new IOException("Stream closed");
        }
        if (this.mStream != null) {
            return;
        }
        long blockSize = this.getBlockSize();
        this.mEndPos = endPos = this.mPos + blockSize - this.mPos % blockSize;
        this.mStream = this.createStream(this.mPos, endPos);
    }
}

