/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs;

import alluxio.Seekable;
import alluxio.exception.ExceptionMessage;
import alluxio.underfs.ObjectUnderFileSystem;
import alluxio.underfs.options.OpenOptions;
import com.google.common.io.CountingInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class ObjectUnderFileInputStream
extends InputStream
implements Seekable {
    private long mInitPos;
    private ObjectUnderFileSystem mUfs;
    private String mKey;
    private CountingInputStream mStream;

    public ObjectUnderFileInputStream(ObjectUnderFileSystem ufs, String key, OpenOptions options) throws IOException {
        this.mUfs = ufs;
        this.mKey = key;
        this.openStream(options);
    }

    @Override
    public void close() throws IOException {
        this.mStream.close();
    }

    @Override
    public int read() throws IOException {
        return this.mStream.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.mStream.read(b, off, len);
    }

    @Override
    public void seek(long position) throws IOException {
        long currentPos = this.mInitPos + this.mStream.getCount();
        if (position == currentPos) {
            return;
        }
        if (position > currentPos) {
            long toSkip = position - currentPos;
            if (toSkip != this.skip(toSkip)) {
                throw new IOException(ExceptionMessage.FAILED_SEEK.getMessage(position));
            }
        } else {
            this.openStream(OpenOptions.defaults().setOffset(position));
        }
    }

    @Override
    public long skip(long n) throws IOException {
        return this.mStream.skip(n);
    }

    private void openStream(OpenOptions options) throws IOException {
        if (this.mStream != null) {
            this.mStream.close();
        }
        this.mInitPos = options.getOffset();
        this.mStream = new CountingInputStream(this.mUfs.openObject(this.mKey, options));
    }
}

