/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.PropertyKey;
import alluxio.exception.ExceptionMessage;
import alluxio.underfs.BaseUnderFileSystem;
import alluxio.underfs.ObjectUnderFileInputStream;
import alluxio.underfs.UnderFileStatus;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.options.CreateOptions;
import alluxio.underfs.options.DeleteOptions;
import alluxio.underfs.options.FileLocationOptions;
import alluxio.underfs.options.ListOptions;
import alluxio.underfs.options.MkdirsOptions;
import alluxio.underfs.options.OpenOptions;
import alluxio.util.CommonUtils;
import alluxio.util.io.PathUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class ObjectUnderFileSystem
extends BaseUnderFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private static final int DEFAULT_MAX_LISTING_CHUNK_LENGTH = 1000;
    protected static final char PATH_SEPARATOR_CHAR = '/';
    protected static final String PATH_SEPARATOR = String.valueOf('/');

    protected ObjectUnderFileSystem(AlluxioURI uri) {
        super(uri);
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void connectFromMaster(String hostname) {
    }

    @Override
    public void connectFromWorker(String hostname) {
    }

    @Override
    public OutputStream create(String path, CreateOptions options) throws IOException {
        if (options.getCreateParent() && !this.mkdirs(this.getParentPath(path))) {
            throw new IOException(ExceptionMessage.PARENT_CREATION_FAILED.getMessage(path));
        }
        return this.createObject(this.stripPrefixIfPresent(path));
    }

    @Override
    public boolean deleteFile(String path) throws IOException {
        return this.deleteObject(this.stripPrefixIfPresent(path));
    }

    @Override
    public boolean deleteDirectory(String path, DeleteOptions options) throws IOException {
        if (!options.isRecursive()) {
            UnderFileStatus[] children = this.listInternal(path, ListOptions.defaults());
            if (children == null) {
                LOG.error("Unable to delete path because {} is not a directory ", (Object)path);
                return false;
            }
            if (children.length != 0) {
                LOG.error("Unable to delete {} because it is a non empty directory. Specify recursive as true in order to delete non empty directories.", (Object)path);
                return false;
            }
        } else {
            UnderFileStatus[] pathsToDelete = this.listInternal(path, ListOptions.defaults().setRecursive(true));
            if (pathsToDelete == null) {
                LOG.error("Unable to delete {} because listInternal returns null", (Object)path);
                return false;
            }
            for (UnderFileStatus pathToDelete : pathsToDelete) {
                String pathKey = this.stripPrefixIfPresent(PathUtils.concatPath(path, pathToDelete.getName()));
                if (pathToDelete.isDirectory()) {
                    if (this.deleteObject(this.convertToFolderName(pathKey))) continue;
                    LOG.warn("Failed to delete directory {}", (Object)pathToDelete.getName());
                    continue;
                }
                if (this.deleteObject(pathKey)) continue;
                LOG.error("Failed to delete file {}", (Object)pathToDelete.getName());
                return false;
            }
        }
        return this.deleteObject(this.stripPrefixIfPresent(this.convertToFolderName(path)));
    }

    @Override
    public long getBlockSizeByte(String path) throws IOException {
        return Configuration.getBytes(PropertyKey.USER_BLOCK_SIZE_BYTES_DEFAULT);
    }

    @Override
    public Object getConf() {
        LOG.debug("getConf is not supported when using default ObjectUnderFileSystem.");
        return null;
    }

    @Override
    public List<String> getFileLocations(String path) throws IOException {
        LOG.debug("getFileLocations is not supported when using default ObjectUnderFileSystem.");
        return null;
    }

    @Override
    public List<String> getFileLocations(String path, FileLocationOptions options) throws IOException {
        LOG.debug("getFileLocations is not supported when using default ObjectUnderFileSystem.");
        return null;
    }

    @Override
    public long getSpace(String path, UnderFileSystem.SpaceType type) throws IOException {
        return -1L;
    }

    @Override
    public long getFileSize(String path) throws IOException {
        ObjectStatus details = this.getObjectStatus(this.stripPrefixIfPresent(path));
        if (details != null) {
            return details.getContentLength();
        }
        LOG.error("Error fetching file size, assuming file does not exist");
        throw new FileNotFoundException(path);
    }

    @Override
    public long getModificationTimeMs(String path) throws IOException {
        ObjectStatus details = this.getObjectStatus(this.stripPrefixIfPresent(path));
        if (details != null) {
            return details.getLastModifiedTimeMs();
        }
        throw new FileNotFoundException(path);
    }

    @Override
    public boolean isDirectory(String path) throws IOException {
        if (this.isRoot(path)) {
            return true;
        }
        String keyAsFolder = this.convertToFolderName(this.stripPrefixIfPresent(path));
        if (this.getObjectStatus(keyAsFolder) != null) {
            return true;
        }
        return this.getObjectListingChunkAndCreateNonEmpty(path, true) != null;
    }

    @Override
    public boolean isFile(String path) throws IOException {
        return !this.isRoot(path) && this.getObjectStatus(this.stripPrefixIfPresent(path)) != null;
    }

    @Override
    public UnderFileStatus[] listStatus(String path) throws IOException {
        return this.listInternal(path, ListOptions.defaults());
    }

    @Override
    public UnderFileStatus[] listStatus(String path, ListOptions options) throws IOException {
        return this.listInternal(path, options);
    }

    @Override
    public boolean mkdirs(String path, MkdirsOptions options) throws IOException {
        if (path == null) {
            return false;
        }
        if (this.isDirectory(path)) {
            return true;
        }
        if (this.isFile(path)) {
            LOG.error("Cannot create directory {} because it is already a file.", (Object)path);
            return false;
        }
        if (!options.getCreateParent()) {
            if (this.parentExists(path)) {
                return this.mkdirsInternal(path);
            }
            LOG.error("Cannot create directory {} because parent does not exist", (Object)path);
            return false;
        }
        if (this.parentExists(path)) {
            return this.mkdirsInternal(path);
        }
        String parentKey = this.getParentPath(path);
        return this.mkdirs(parentKey) && this.mkdirsInternal(path);
    }

    @Override
    public InputStream open(String path, OpenOptions options) throws IOException {
        return new ObjectUnderFileInputStream(this, this.stripPrefixIfPresent(path), options);
    }

    @Override
    public boolean renameDirectory(String src, String dst) throws IOException {
        UnderFileStatus[] children = this.listInternal(src, ListOptions.defaults());
        if (children == null) {
            LOG.error("Failed to list directory {}, aborting rename.", (Object)src);
            return false;
        }
        if (this.exists(dst)) {
            LOG.error("Unable to rename {} to {} because destination already exists.", (Object)src, (Object)dst);
            return false;
        }
        if (!this.copyObject(this.stripPrefixIfPresent(this.convertToFolderName(src)), this.stripPrefixIfPresent(this.convertToFolderName(dst)))) {
            return false;
        }
        for (UnderFileStatus child : children) {
            String childSrcPath = PathUtils.concatPath(src, child);
            String childDstPath = PathUtils.concatPath(dst, child);
            boolean success = child.isDirectory() ? this.renameDirectory(childSrcPath, childDstPath) : this.renameFile(childSrcPath, childDstPath);
            if (success) continue;
            LOG.error("Failed to rename path {}, aborting rename.", (Object)child);
            return false;
        }
        return this.deleteDirectory(src, DeleteOptions.defaults().setRecursive(true));
    }

    @Override
    public boolean renameFile(String src, String dst) throws IOException {
        if (!this.isFile(src)) {
            LOG.error("Unable to rename {} to {} because source does not exist or is a directory.", (Object)src, (Object)dst);
            return false;
        }
        if (this.exists(dst)) {
            LOG.error("Unable to rename {} to {} because destination already exists.", (Object)src, (Object)dst);
            return false;
        }
        return this.copyObject(this.stripPrefixIfPresent(src), this.stripPrefixIfPresent(dst)) && this.deleteObject(this.stripPrefixIfPresent(src));
    }

    @Override
    public void setConf(Object conf) {
    }

    @Override
    public boolean supportsFlush() {
        return false;
    }

    protected abstract boolean createEmptyObject(String var1);

    protected abstract OutputStream createObject(String var1) throws IOException;

    protected String convertToFolderName(String key) {
        key = CommonUtils.stripSuffixIfPresent(key, PATH_SEPARATOR);
        return key + this.getFolderSuffix();
    }

    protected abstract boolean copyObject(String var1, String var2) throws IOException;

    protected abstract boolean deleteObject(String var1) throws IOException;

    protected int getListingChunkLengthMax() {
        return 1000;
    }

    protected int getListingChunkLength() {
        return Configuration.getInt(PropertyKey.UNDERFS_LISTING_LENGTH) > this.getListingChunkLengthMax() ? this.getListingChunkLengthMax() : Configuration.getInt(PropertyKey.UNDERFS_LISTING_LENGTH);
    }

    protected abstract ObjectStatus getObjectStatus(String var1);

    protected String getParentPath(String path) {
        if (this.isRoot(path)) {
            return null;
        }
        int separatorIndex = path.lastIndexOf(PATH_SEPARATOR);
        if (separatorIndex < 0) {
            return null;
        }
        return path.substring(0, separatorIndex);
    }

    protected boolean isRoot(String path) {
        return PathUtils.normalizePath(path, PATH_SEPARATOR).equals(PathUtils.normalizePath(this.getRootKey(), PATH_SEPARATOR));
    }

    protected String getChildName(String child, String parent) throws IOException {
        if (child.startsWith(parent)) {
            return child.substring(parent.length());
        }
        throw new IOException(ExceptionMessage.INVALID_PREFIX.getMessage(parent, child));
    }

    protected abstract String getFolderSuffix();

    protected abstract ObjectListingChunk getObjectListingChunk(String var1, boolean var2) throws IOException;

    protected ObjectListingChunk getObjectListingChunkAndCreateNonEmpty(String path, boolean recursive) throws IOException {
        String dir = this.stripPrefixIfPresent(path);
        ObjectListingChunk objs = this.getObjectListingChunk(dir, recursive);
        if (objs != null && (objs.getObjectNames() != null && objs.getObjectNames().length > 0 || objs.getCommonPrefixes() != null && objs.getCommonPrefixes().length > 0)) {
            this.mkdirsInternal(dir);
            return objs;
        }
        return null;
    }

    protected abstract String getRootKey();

    protected UnderFileStatus[] listInternal(String path, ListOptions options) throws IOException {
        ObjectListingChunk chunk = this.getObjectListingChunkAndCreateNonEmpty(path, options.isRecursive());
        if (chunk == null) {
            String keyAsFolder = this.convertToFolderName(this.stripPrefixIfPresent(path));
            if (this.getObjectStatus(keyAsFolder) != null) {
                return new UnderFileStatus[0];
            }
            return null;
        }
        String keyPrefix = PathUtils.normalizePath(this.stripPrefixIfPresent(path), PATH_SEPARATOR);
        keyPrefix = keyPrefix.equals(PATH_SEPARATOR) ? "" : keyPrefix;
        HashMap<String, Boolean> children = new HashMap<String, Boolean>();
        while (chunk != null) {
            String[] commonPrefixes;
            for (String obj : chunk.getObjectNames()) {
                String child = this.getChildName(obj, keyPrefix);
                boolean isDir = child.endsWith(this.getFolderSuffix());
                if ((child = CommonUtils.stripSuffixIfPresent(child, this.getFolderSuffix())).isEmpty()) continue;
                children.put(child, isDir);
            }
            if (options.isRecursive()) {
                HashSet<String> prefixes = new HashSet<String>();
                for (String objectName : chunk.getObjectNames()) {
                    while (objectName.startsWith(keyPrefix)) {
                        if ((objectName = objectName.substring(0, objectName.lastIndexOf(PATH_SEPARATOR))).isEmpty()) continue;
                        prefixes.add(objectName);
                    }
                }
                commonPrefixes = prefixes.toArray(new String[prefixes.size()]);
            } else {
                commonPrefixes = chunk.getCommonPrefixes();
            }
            for (String commonPrefix : commonPrefixes) {
                if (!commonPrefix.startsWith(keyPrefix)) continue;
                String child = this.getChildName(commonPrefix, keyPrefix);
                int childNameIndex = child.lastIndexOf(PATH_SEPARATOR);
                String string = child = childNameIndex != -1 ? child.substring(0, childNameIndex) : child;
                if (child.isEmpty() || children.containsKey(child)) continue;
                this.mkdirsInternal(commonPrefix);
                children.put(child, true);
            }
            chunk = chunk.getNextChunk();
        }
        UnderFileStatus[] ret = new UnderFileStatus[children.size()];
        int pos = 0;
        for (Map.Entry entry : children.entrySet()) {
            ret[pos++] = new UnderFileStatus((String)entry.getKey(), (Boolean)entry.getValue());
        }
        return ret;
    }

    protected boolean mkdirsInternal(String key) {
        return this.createEmptyObject(this.convertToFolderName(this.stripPrefixIfPresent(key)));
    }

    protected abstract InputStream openObject(String var1, OpenOptions var2) throws IOException;

    protected boolean parentExists(String path) throws IOException {
        if (this.isRoot(path)) {
            return true;
        }
        String parentKey = this.getParentPath(path);
        return parentKey != null && this.isDirectory(parentKey);
    }

    private String stripPrefixIfPresent(String path) {
        String stripedKey = CommonUtils.stripPrefixIfPresent(path, PathUtils.normalizePath(this.getRootKey(), PATH_SEPARATOR));
        if (!stripedKey.equals(path)) {
            return stripedKey;
        }
        return CommonUtils.stripPrefixIfPresent(path, PATH_SEPARATOR);
    }

    public static interface ObjectListingChunk {
        public String[] getObjectNames();

        public String[] getCommonPrefixes();

        public ObjectListingChunk getNextChunk() throws IOException;
    }

    protected class ObjectStatus {
        final long mContentLength;
        final long mLastModifiedTimeMs;

        public ObjectStatus(long contentLength, long lastModifiedTimeMs) {
            this.mContentLength = contentLength;
            this.mLastModifiedTimeMs = lastModifiedTimeMs;
        }

        public long getContentLength() {
            return this.mContentLength;
        }

        public long getLastModifiedTimeMs() {
            return this.mLastModifiedTimeMs;
        }
    }
}

