/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs;

import alluxio.AlluxioURI;
import alluxio.underfs.UnderFileStatus;
import alluxio.underfs.UnderFileSystemRegistry;
import alluxio.underfs.options.CreateOptions;
import alluxio.underfs.options.DeleteOptions;
import alluxio.underfs.options.FileLocationOptions;
import alluxio.underfs.options.ListOptions;
import alluxio.underfs.options.MkdirsOptions;
import alluxio.underfs.options.OpenOptions;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public interface UnderFileSystem {
    public void close() throws IOException;

    public void configureProperties() throws IOException;

    public void connectFromMaster(String var1) throws IOException;

    public void connectFromWorker(String var1) throws IOException;

    public OutputStream create(String var1) throws IOException;

    public OutputStream create(String var1, CreateOptions var2) throws IOException;

    public boolean deleteDirectory(String var1) throws IOException;

    public boolean deleteDirectory(String var1, DeleteOptions var2) throws IOException;

    public boolean deleteFile(String var1) throws IOException;

    public boolean exists(String var1) throws IOException;

    public long getBlockSizeByte(String var1) throws IOException;

    public Object getConf();

    public List<String> getFileLocations(String var1) throws IOException;

    public List<String> getFileLocations(String var1, FileLocationOptions var2) throws IOException;

    public long getFileSize(String var1) throws IOException;

    public String getGroup(String var1) throws IOException;

    public short getMode(String var1) throws IOException;

    public long getModificationTimeMs(String var1) throws IOException;

    public String getOwner(String var1) throws IOException;

    public Map<String, String> getProperties();

    public long getSpace(String var1, SpaceType var2) throws IOException;

    public String getUnderFSType();

    public boolean isDirectory(String var1) throws IOException;

    public boolean isFile(String var1) throws IOException;

    public UnderFileStatus[] listStatus(String var1) throws IOException;

    public UnderFileStatus[] listStatus(String var1, ListOptions var2) throws IOException;

    public boolean mkdirs(String var1) throws IOException;

    public boolean mkdirs(String var1, MkdirsOptions var2) throws IOException;

    public InputStream open(String var1) throws IOException;

    public InputStream open(String var1, OpenOptions var2) throws IOException;

    public boolean renameDirectory(String var1, String var2) throws IOException;

    public boolean renameFile(String var1, String var2) throws IOException;

    public AlluxioURI resolveUri(AlluxioURI var1, String var2);

    public void setConf(Object var1);

    public void setOwner(String var1, String var2, String var3) throws IOException;

    public void setProperties(Map<String, String> var1);

    public void setMode(String var1, short var2) throws IOException;

    public boolean supportsFlush();

    public static enum SpaceType {
        SPACE_TOTAL(0),
        SPACE_FREE(1),
        SPACE_USED(2);

        private final int mValue;

        private SpaceType(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }
    }

    public static class Factory {
        private static final Cache UFS_CACHE = new Cache();

        private Factory() {
        }

        public static void clearCache() {
            UFS_CACHE.clear();
        }

        public static UnderFileSystem get(String path) {
            return Factory.get(path, null);
        }

        public static UnderFileSystem get(String path, Object ufsConf) {
            Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"path may not be null");
            return UFS_CACHE.get(path, ufsConf);
        }

        private static class Key {
            private final String mScheme;
            private final String mAuthority;

            Key(AlluxioURI uri) {
                this.mScheme = uri.getScheme() == null ? "" : uri.getScheme().toLowerCase();
                this.mAuthority = uri.getAuthority() == null ? "" : uri.getAuthority().toLowerCase();
            }

            public int hashCode() {
                return Objects.hashCode((Object[])new Object[]{this.mScheme, this.mAuthority});
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (!(object instanceof Key)) {
                    return false;
                }
                Key that = (Key)object;
                return Objects.equal((Object)this.mScheme, (Object)that.mScheme) && Objects.equal((Object)this.mAuthority, (Object)that.mAuthority);
            }

            public String toString() {
                return this.mScheme + "://" + this.mAuthority;
            }
        }

        @ThreadSafe
        private static final class Cache {
            private final ConcurrentHashMap<Key, UnderFileSystem> mUnderFileSystemMap = new ConcurrentHashMap();

            private Cache() {
            }

            UnderFileSystem get(String path, Object ufsConf) {
                Key key = new Key(new AlluxioURI(path));
                UnderFileSystem cachedFs = this.mUnderFileSystemMap.get(key);
                if (cachedFs != null) {
                    return cachedFs;
                }
                UnderFileSystem fs = UnderFileSystemRegistry.create(path, ufsConf);
                cachedFs = this.mUnderFileSystemMap.putIfAbsent(key, fs);
                if (cachedFs == null) {
                    return fs;
                }
                try {
                    fs.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return cachedFs;
            }

            void clear() {
                this.mUnderFileSystemMap.clear();
            }
        }
    }
}

