/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs;

import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.UnderFileSystemFactory;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class UnderFileSystemRegistry {
    private static final List<UnderFileSystemFactory> FACTORIES = new CopyOnWriteArrayList<UnderFileSystemFactory>();
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private static boolean sInit = false;

    private UnderFileSystemRegistry() {
    }

    public static List<UnderFileSystemFactory> available() {
        return Collections.unmodifiableList(FACTORIES);
    }

    public static UnderFileSystem create(String path, Object ufsConf) {
        List<UnderFileSystemFactory> factories = UnderFileSystemRegistry.findAll(path);
        if (factories.isEmpty()) {
            throw new IllegalArgumentException("No Under File System Factory found for: " + path);
        }
        ArrayList<Exception> errors = new ArrayList<Exception>();
        for (UnderFileSystemFactory factory : factories) {
            try {
                return factory.create(path, ufsConf);
            }
            catch (Exception exception) {
                errors.add(exception);
            }
        }
        StringBuilder errorStr = new StringBuilder();
        errorStr.append("All eligible Under File Systems were unable to create an instance for the given path: ").append(path).append('\n');
        for (Throwable throwable : errors) {
            errorStr.append(throwable).append('\n');
        }
        throw new IllegalArgumentException(errorStr.toString());
    }

    public static UnderFileSystemFactory find(String path) {
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"path may not be null");
        for (UnderFileSystemFactory factory : FACTORIES) {
            if (!factory.supportsPath(path)) continue;
            LOG.debug("Selected Under File System Factory implementation {} for path {}", factory.getClass(), (Object)path);
            return factory;
        }
        LOG.warn("No Under File System Factory implementation supports the path {}. Please check if the under storage path is valid.", (Object)path);
        return null;
    }

    public static List<UnderFileSystemFactory> findAll(String path) {
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"path may not be null");
        ArrayList<UnderFileSystemFactory> eligibleFactories = new ArrayList<UnderFileSystemFactory>();
        for (UnderFileSystemFactory factory : FACTORIES) {
            if (!factory.supportsPath(path)) continue;
            LOG.debug("Under File System Factory implementation {} is eligible for path {}", factory.getClass(), (Object)path);
            eligibleFactories.add(factory);
        }
        if (eligibleFactories.isEmpty()) {
            LOG.warn("No Under File System Factory implementation supports the path {}", (Object)path);
        }
        return eligibleFactories;
    }

    private static synchronized void init() {
        if (sInit) {
            return;
        }
        ServiceLoader<UnderFileSystemFactory> discoveredFactories = ServiceLoader.load(UnderFileSystemFactory.class, UnderFileSystemFactory.class.getClassLoader());
        for (UnderFileSystemFactory factory : discoveredFactories) {
            LOG.debug("Discovered Under File System Factory implementation {} - {}", factory.getClass(), (Object)factory.toString());
            FACTORIES.add(factory);
        }
        sInit = true;
    }

    public static void register(UnderFileSystemFactory factory) {
        if (factory == null) {
            return;
        }
        LOG.debug("Registered Under File System Factory implementation {} - {}", factory.getClass(), (Object)factory.toString());
        FACTORIES.add(0, factory);
    }

    public static synchronized void reset() {
        if (sInit) {
            sInit = false;
            FACTORIES.clear();
        }
        UnderFileSystemRegistry.init();
    }

    public static void unregister(UnderFileSystemFactory factory) {
        if (factory == null) {
            return;
        }
        LOG.debug("Unregistered Under File System Factory implementation {} - {}", factory.getClass(), (Object)factory.toString());
        FACTORIES.remove(factory);
    }

    static {
        UnderFileSystemRegistry.init();
    }
}

